/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;

public class RubyDateFormat
extends DateFormat {
    private static final long serialVersionUID = -250429218019023997L;
    private List<Token> compiledPattern;
    private final DateFormatSymbols formatSymbols;
    private static final int FORMAT_STRING = 0;
    private static final int FORMAT_WEEK_LONG = 1;
    private static final int FORMAT_WEEK_SHORT = 2;
    private static final int FORMAT_MONTH_LONG = 3;
    private static final int FORMAT_MONTH_SHORT = 4;
    private static final int FORMAT_DAY = 5;
    private static final int FORMAT_DAY_S = 6;
    private static final int FORMAT_HOUR = 7;
    private static final int FORMAT_HOUR_M = 8;
    private static final int FORMAT_DAY_YEAR = 9;
    private static final int FORMAT_MINUTES = 10;
    private static final int FORMAT_MONTH = 11;
    private static final int FORMAT_MERIDIAN = 12;
    private static final int FORMAT_SECONDS = 13;
    private static final int FORMAT_WEEK_YEAR_S = 14;
    private static final int FORMAT_WEEK_YEAR_M = 15;
    private static final int FORMAT_DAY_WEEK = 16;
    private static final int FORMAT_YEAR_LONG = 17;
    private static final int FORMAT_YEAR_SHORT = 18;
    private static final int FORMAT_ZONE_OFF = 19;
    private static final int FORMAT_ZONE_ID = 20;
    private DateTime dt;

    public RubyDateFormat() {
        this("", new DateFormatSymbols());
    }

    public RubyDateFormat(String pattern, Locale aLocale) {
        this(pattern, new DateFormatSymbols(aLocale));
    }

    public RubyDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        this.formatSymbols = formatSymbols;
        this.applyPattern(pattern);
    }

    public void applyPattern(String pattern) {
        this.compilePattern(pattern);
    }

    private void compilePattern(String pattern) {
        this.compiledPattern = new LinkedList<Token>();
        int len = pattern.length();
        int i = 0;
        while (i < len) {
            if (pattern.charAt(i) == '%') {
                switch (pattern.charAt(++i)) {
                    case 'A': {
                        this.compiledPattern.add(new Token(1));
                        break;
                    }
                    case 'a': {
                        this.compiledPattern.add(new Token(2));
                        break;
                    }
                    case 'B': {
                        this.compiledPattern.add(new Token(3));
                        break;
                    }
                    case 'b': {
                        this.compiledPattern.add(new Token(4));
                        break;
                    }
                    case 'c': {
                        this.compiledPattern.add(new Token(2));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(4));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(10));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(13));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(17));
                        break;
                    }
                    case 'D': {
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(18));
                        break;
                    }
                    case 'd': {
                        this.compiledPattern.add(new Token(5));
                        break;
                    }
                    case 'e': {
                        this.compiledPattern.add(new Token(6));
                        break;
                    }
                    case 'F': {
                        this.compiledPattern.add(new Token(17));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(5));
                        break;
                    }
                    case 'H': {
                        this.compiledPattern.add(new Token(7));
                        break;
                    }
                    case 'I': {
                        this.compiledPattern.add(new Token(8));
                        break;
                    }
                    case 'j': {
                        this.compiledPattern.add(new Token(9));
                        break;
                    }
                    case 'M': {
                        this.compiledPattern.add(new Token(10));
                        break;
                    }
                    case 'm': {
                        this.compiledPattern.add(new Token(11));
                        break;
                    }
                    case 'p': {
                        this.compiledPattern.add(new Token(12));
                        break;
                    }
                    case 'R': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(10));
                        break;
                    }
                    case 'S': {
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 'T': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(10));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 'U': {
                        this.compiledPattern.add(new Token(14));
                        break;
                    }
                    case 'W': {
                        this.compiledPattern.add(new Token(15));
                        break;
                    }
                    case 'w': {
                        this.compiledPattern.add(new Token(16));
                        break;
                    }
                    case 'X': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(10));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 'x': {
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(18));
                        break;
                    }
                    case 'Y': {
                        this.compiledPattern.add(new Token(17));
                        break;
                    }
                    case 'y': {
                        this.compiledPattern.add(new Token(18));
                        break;
                    }
                    case 'Z': {
                        this.compiledPattern.add(new Token(20));
                        break;
                    }
                    case 'z': {
                        this.compiledPattern.add(new Token(19));
                        break;
                    }
                    case '%': {
                        this.compiledPattern.add(new Token(0, "%"));
                        break;
                    }
                    default: {
                        this.compiledPattern.add(new Token(0, "%" + pattern.charAt(i)));
                    }
                }
                ++i;
                continue;
            }
            StringBuilder sb = new StringBuilder();
            while (i < len && pattern.charAt(i) != '%') {
                sb.append(pattern.charAt(i));
                ++i;
            }
            this.compiledPattern.add(new Token(0, sb.toString()));
        }
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public StringBuffer format(Date ignored, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        for (Token token : this.compiledPattern) {
            switch (token.getFormat()) {
                case 0: {
                    toAppendTo.append(token.getData());
                    break;
                }
                case 1: {
                    int v = (this.dt.getDayOfWeek() + 1) % 8;
                    if (v == 0) {
                        ++v;
                    }
                    toAppendTo.append(this.formatSymbols.getWeekdays()[v]);
                    break;
                }
                case 2: {
                    int v = (this.dt.getDayOfWeek() + 1) % 8;
                    if (v == 0) {
                        ++v;
                    }
                    toAppendTo.append(this.formatSymbols.getShortWeekdays()[v]);
                    break;
                }
                case 3: {
                    toAppendTo.append(this.formatSymbols.getMonths()[this.dt.getMonthOfYear() - 1]);
                    break;
                }
                case 4: {
                    toAppendTo.append(this.formatSymbols.getShortMonths()[this.dt.getMonthOfYear() - 1]);
                    break;
                }
                case 5: {
                    int value2 = this.dt.getDayOfMonth();
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 6: {
                    int value2 = this.dt.getDayOfMonth();
                    if (value2 < 10) {
                        toAppendTo.append(' ');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 7: {
                    int value2 = this.dt.getHourOfDay();
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 8: {
                    int value2 = this.dt.getHourOfDay();
                    if (value2 > 12) {
                        value2 -= 12;
                    }
                    if (value2 == 0) {
                        toAppendTo.append("12");
                        break;
                    }
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 9: {
                    int value2 = this.dt.getDayOfYear();
                    if (value2 < 10) {
                        toAppendTo.append("00");
                    } else if (value2 < 100) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 10: {
                    int value2 = this.dt.getMinuteOfHour();
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 11: {
                    int value2 = this.dt.getMonthOfYear();
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 12: {
                    if (this.dt.getHourOfDay() < 12) {
                        toAppendTo.append("AM");
                        break;
                    }
                    toAppendTo.append("PM");
                    break;
                }
                case 13: {
                    int value2 = this.dt.getSecondOfMinute();
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 15: {
                    this.formatWeekYear(2, toAppendTo);
                    break;
                }
                case 14: {
                    this.formatWeekYear(1, toAppendTo);
                    break;
                }
                case 16: {
                    int value2 = this.dt.getDayOfWeek();
                    toAppendTo.append(value2);
                    break;
                }
                case 17: {
                    int value2 = this.dt.getYear();
                    if (value2 < 10) {
                        toAppendTo.append("000");
                    } else if (value2 < 100) {
                        toAppendTo.append("00");
                    } else if (value2 < 1000) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 18: {
                    int value2 = this.dt.getYear() % 100;
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 19: {
                    int value2 = this.dt.getZone().getOffset(this.dt.getMillis());
                    if (value2 < 0) {
                        toAppendTo.append('-');
                    } else {
                        toAppendTo.append('+');
                    }
                    value2 = Math.abs(value2);
                    if (value2 / 3600000 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2 / 3600000);
                    value2 = value2 % 3600000 / 60000;
                    if (value2 < 10) {
                        toAppendTo.append('0');
                    }
                    toAppendTo.append(value2);
                    break;
                }
                case 20: {
                    toAppendTo.append(this.dt.getZone().getShortName(this.dt.getMillis()));
                }
            }
        }
        return toAppendTo;
    }

    private void formatWeekYear(int firstDayOfWeek, StringBuffer toAppendTo) {
        GregorianCalendar calendar = this.dt.toGregorianCalendar();
        calendar.setFirstDayOfWeek(firstDayOfWeek);
        calendar.setMinimalDaysInFirstWeek(7);
        int value2 = calendar.get(3);
        if ((value2 == 52 || value2 == 53) && calendar.get(2) == 0) {
            value2 = 0;
        }
        if (value2 < 10) {
            toAppendTo.append('0');
        }
        toAppendTo.append(value2);
    }

    public Date parse(String source2, ParsePosition pos2) {
        throw new UnsupportedOperationException();
    }

    private static class Token {
        private int format;
        private Object data;

        public Token(int format) {
            this(format, null);
        }

        public Token(int format, Object data) {
            this.format = format;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public int getFormat() {
            return this.format;
        }
    }
}

