/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ext.posix.util.FieldAccess;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static final boolean DEBUG = false;
    private static final Class UNIXProcess;
    private static final Field UNIXProcess_pid;
    private static final Class ProcessImpl;
    private static final Field ProcessImpl_handle;
    private static final PidGetter PID_GETTER;

    private static String[] getCurrentEnv(Ruby runtime2) {
        RubyHash hash2 = (RubyHash)runtime2.getObject().fastGetConstant("ENV");
        String[] ret = new String[hash2.size()];
        int i = 0;
        for (Map.Entry e : hash2.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static int runAndWaitNoError(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWaitNoError(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static long runWithoutWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runWithoutWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static int execAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        String[] args2 = ShellLauncher.parseCommandLine(runtime2.getCurrentContext(), runtime2, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime2, args2)) {
            try {
                int startIndex;
                File pwd = new File(runtime2.getCurrentDirectory());
                String command = args2[0];
                int n = startIndex = command.endsWith(".rb") ? 0 : 1;
                if (command.trim().endsWith("irb")) {
                    startIndex = 0;
                    args2[0] = runtime2.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
                }
                String[] newargs = new String[args2.length - startIndex];
                System.arraycopy(args2, startIndex, newargs, 0, newargs.length);
                ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime2), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime2.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runAndWait(runtime2, rawArgs);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error2 = runtime2.getErrorStream();
        InputStream input = runtime2.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime2, rawArgs);
            ShellLauncher.handleStreams(aProcess, input, output, error2);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    public static int runAndWaitNoError(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        InputStream input = runtime2.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime2, rawArgs);
            ShellLauncher.handleStreams(aProcess, input, output);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    public static long runWithoutWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        try {
            POpenProcess aProcess = new POpenProcess(ShellLauncher.popenShared(runtime2, rawArgs), runtime2);
            return ShellLauncher.getPidFromProcess(aProcess);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    public static long getPidFromProcess(Process process) {
        if (process instanceof ScriptThreadProcess) {
            return process.hashCode();
        }
        if (process instanceof POpenProcess) {
            return ShellLauncher.reflectPidFromProcess(((POpenProcess)process).getChild());
        }
        return ShellLauncher.reflectPidFromProcess(process);
    }

    public static long reflectPidFromProcess(Process process) {
        return PID_GETTER.getPid(process);
    }

    public static Process run(Ruby runtime2, IRubyObject string2) throws IOException {
        return ShellLauncher.run(runtime2, new IRubyObject[]{string2});
    }

    public static POpenProcess popen(Ruby runtime2, IRubyObject string2, ModeFlags modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, new IRubyObject[]{string2}), runtime2, modes);
    }

    public static POpenProcess popen3(Ruby runtime2, IRubyObject[] strings) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, strings), runtime2);
    }

    private static Process popenShared(Ruby runtime2, IRubyObject[] strings) throws IOException {
        String shell = ShellLauncher.getShell(runtime2);
        Process childProcess = null;
        File pwd = new File(runtime2.getCurrentDirectory());
        if (strings.length == 1) {
            String[] argArray = new String[]{shell, shell.endsWith("sh") ? "-c" : "/c", strings[0].asJavaString()};
            childProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime2), pwd);
        } else {
            String[] args2 = ShellLauncher.parseCommandLine(runtime2.getCurrentContext(), runtime2, strings);
            childProcess = Runtime.getRuntime().exec(args2, ShellLauncher.getCurrentEnv(runtime2), pwd);
        }
        return childProcess;
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        while (filteredStream instanceof FilterOutputStream) {
            try {
                filteredStream = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, "out", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        while (filteredStream instanceof FilterInputStream) {
            try {
                filteredStream = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, "in", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static Process run(Ruby runtime2, IRubyObject[] rawArgs) throws IOException {
        String shell = ShellLauncher.getShell(runtime2);
        Process aProcess = null;
        File pwd = new File(runtime2.getCurrentDirectory());
        String[] args2 = ShellLauncher.parseCommandLine(runtime2.getCurrentContext(), runtime2, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime2, args2)) {
            int startIndex;
            String command = args2[0];
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                args2[0] = runtime2.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            String[] newargs = new String[args2.length - startIndex];
            System.arraycopy(args2, startIndex, newargs, 0, newargs.length);
            ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime2), pwd);
            ipScript.start();
            aProcess = ipScript;
        } else if (rawArgs.length == 1 && ShellLauncher.shouldRunInShell(shell, args2)) {
            String[] argArray = new String[3];
            String cmdline = rawArgs[0].toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            aProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime2), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(args2, ShellLauncher.getCurrentEnv(runtime2), pwd);
        }
        return aProcess;
    }

    private static void handleStreams(Process p2, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        OutputStream pIn = p2.getOutputStream();
        StreamPumper t1 = new StreamPumper(pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t2 = new StreamPumper(pErr, err, false, Pumper.Slave.IN, p2);
        StreamPumper t3 = new StreamPumper(in, pIn, true, Pumper.Slave.OUT, p2);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException io2) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException io3) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io4) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io5) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException io6) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    private static void handleStreams(Process p2, InputStream in, OutputStream out) throws IOException {
        InputStream pOut = p2.getInputStream();
        p2.getErrorStream().close();
        OutputStream pIn = p2.getOutputStream();
        StreamPumper t1 = new StreamPumper(pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t3 = new StreamPumper(in, pIn, true, Pumper.Slave.OUT, p2);
        t1.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            out.flush();
        }
        catch (IOException io2) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io3) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io4) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseCommandLine(ThreadContext context, Ruby runtime2, IRubyObject[] rawArgs) {
        String[] args2;
        if (rawArgs.length == 1) {
            LoadService loadService = runtime2.getLoadService();
            synchronized (loadService) {
                runtime2.getLoadService().require("jruby/path_helper");
            }
            RubyModule pathHelper = runtime2.getClassFromPath("JRuby::PathHelper");
            RubyArray parts = (RubyArray)RuntimeHelpers.invoke(context, (IRubyObject)pathHelper, "smart_split_command", rawArgs);
            args2 = new String[parts.getLength()];
            for (int i = 0; i < parts.getLength(); ++i) {
                args2[i] = parts.entry(i).toString();
            }
        } else {
            args2 = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                args2[i] = rawArgs[i].toString();
            }
        }
        return args2;
    }

    private static boolean shouldRunInProcess(Ruby runtime2, String[] commands) {
        if (!runtime2.getInstanceConfig().isRunRubyInProcess()) {
            return false;
        }
        for (int i = 0; i < commands.length; ++i) {
            String c = commands[i];
            if (c.trim().length() == 0) continue;
            char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
            for (int j = 0; j < firstLast.length; ++j) {
                switch (firstLast[j]) {
                    case '\n': 
                    case '\"': 
                    case '$': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        return false;
                    }
                }
            }
        }
        String command = commands[0];
        String[] slashDelimitedTokens = command.split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        int indexOfRuby = finalToken.indexOf("ruby");
        return indexOfRuby != -1 && indexOfRuby == finalToken.length() - 4 || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
    }

    private static boolean shouldRunInShell(String shell, String[] args2) {
        return !Platform.IS_WINDOWS || shell != null && args2.length > 1 && !new File(args2[0]).exists();
    }

    private static String getShell(Ruby runtime2) {
        return runtime2.evalScriptlet("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
    }

    static {
        PidGetter pg = new PidGetter(){

            public long getPid(Process process) {
                return process.hashCode();
            }
        };
        Class<?> up = null;
        Field pid2 = null;
        try {
            up = Class.forName("java.lang.UNIXProcess");
            pid2 = up.getDeclaredField("pid");
            pid2.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        UNIXProcess = up;
        UNIXProcess_pid = pid2;
        Class<?> pi = null;
        Field handle = null;
        try {
            pi = Class.forName("java.lang.ProcessImpl");
            handle = pi.getDeclaredField("handle");
            handle.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        ProcessImpl = pi;
        ProcessImpl_handle = handle;
        pg = UNIXProcess_pid != null ? (ProcessImpl_handle != null ? new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (UNIXProcess.isInstance(process)) {
                        return ((Integer)UNIXProcess_pid.get(process)).intValue();
                    }
                    if (ProcessImpl.isInstance(process)) {
                        return (Long)ProcessImpl_handle.get(process);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        } : new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (UNIXProcess.isInstance(process)) {
                        return ((Integer)UNIXProcess_pid.get(process)).intValue();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        }) : (ProcessImpl_handle != null ? new PidGetter(){

            public long getPid(Process process) {
                try {
                    if (ProcessImpl.isInstance(process)) {
                        return (Long)ProcessImpl_handle.get(process);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return process.hashCode();
            }
        } : new PidGetter(){

            public long getPid(Process process) {
                return process.hashCode();
            }
        });
        PID_GETTER = pg;
    }

    private static class ChannelPumper
    extends Thread
    implements Pumper {
        private final FileChannel inChannel;
        private final FileChannel outChannel;
        private final Pumper.Slave slave;
        private final Object sync;
        private volatile boolean quit;

        ChannelPumper(FileChannel inChannel, FileChannel outChannel, Pumper.Slave slave, Object sync2) {
            this.inChannel = inChannel;
            this.outChannel = outChannel;
            this.slave = slave;
            this.sync = sync2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ByteBuffer buf = ByteBuffer.allocateDirect(1024);
            buf.clear();
            try {
                while (!this.quit && this.inChannel.isOpen() && this.outChannel.isOpen()) {
                    int read2 = this.inChannel.read(buf);
                    if (read2 == -1) {
                        break;
                    }
                    buf.flip();
                    this.outChannel.write(buf);
                    buf.clear();
                }
            }
            catch (Exception exception2) {
                Object object = this.sync;
                synchronized (object) {
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            finally {
                Object read2 = this.sync;
                synchronized (read2) {
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
            }
        }

        public void quit() {
            this.interrupt();
            this.quit = true;
        }
    }

    private static class StreamPumper
    extends Thread
    implements Pumper {
        private final InputStream in;
        private final OutputStream out;
        private final boolean onlyIfAvailable;
        private final Object waitLock = new Object();
        private final Object sync;
        private final Pumper.Slave slave;
        private volatile boolean quit;

        StreamPumper(InputStream in, OutputStream out, boolean avail, Pumper.Slave slave, Object sync2) {
            this.in = in;
            this.out = out;
            this.onlyIfAvailable = avail;
            this.slave = slave;
            this.sync = sync2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block30: {
                Object object;
                byte[] buf = new byte[1024];
                boolean hasReadSomething = false;
                try {
                    while (!this.quit) {
                        int numRead;
                        if (this.onlyIfAvailable && !hasReadSomething) {
                            if (this.in.available() == 0) {
                                object = this.waitLock;
                                synchronized (object) {
                                    this.waitLock.wait(10L);
                                    continue;
                                }
                            }
                            hasReadSomething = true;
                        }
                        if ((numRead = this.in.read(buf)) == -1) {
                            break;
                        }
                        this.out.write(buf, 0, numRead);
                    }
                }
                catch (Exception exception2) {
                    if (!this.onlyIfAvailable) break block30;
                    Object object2 = this.sync;
                    synchronized (object2) {
                        if (this.slave == Pumper.Slave.OUT) {
                            try {
                                this.out.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    if (this.onlyIfAvailable) {
                        object = this.sync;
                        synchronized (object) {
                            if (this.slave == Pumper.Slave.OUT) {
                                try {
                                    this.out.close();
                                }
                                catch (IOException ioe) {}
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    private static interface Pumper
    extends Runnable {
        public void start();

        public void quit();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Slave {
            IN,
            OUT;

        }
    }

    public static class POpenProcess
    extends Process {
        private final Process child;
        private final Ruby runtime;
        private final ModeFlags modes;
        private InputStream input;
        private OutputStream output;
        private InputStream inerr;
        private FileChannel inputChannel;
        private FileChannel outputChannel;
        private FileChannel inerrChannel;
        private Pumper inputPumper;
        private Pumper inerrPumper;
        private Pumper outputPumper;

        public POpenProcess(Process child, Ruby runtime2, ModeFlags modes) {
            this.child = child;
            this.runtime = runtime2;
            this.modes = modes;
            if (modes.isWritable()) {
                this.prepareOutput(child);
            } else {
                try {
                    child.getOutputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (modes.isReadable()) {
                this.prepareInput(child);
            } else {
                this.pumpInput(child, runtime2);
            }
            this.pumpInerr(child, runtime2);
        }

        public POpenProcess(Process child, Ruby runtime2) {
            this.child = child;
            this.runtime = runtime2;
            this.modes = null;
            this.prepareOutput(child);
            this.prepareInput(child);
            this.prepareInerr(child);
        }

        public OutputStream getOutputStream() {
            return this.output;
        }

        public InputStream getInputStream() {
            return this.input;
        }

        public InputStream getErrorStream() {
            return this.inerr;
        }

        public FileChannel getInput() {
            return this.inputChannel;
        }

        public FileChannel getOutput() {
            return this.outputChannel;
        }

        public FileChannel getError() {
            return this.inerrChannel;
        }

        public boolean hasOutput() {
            return this.output != null || this.outputChannel != null;
        }

        public Process getChild() {
            return this.child;
        }

        public int waitFor() throws InterruptedException {
            if (this.outputPumper == null) {
                try {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
                catch (IOException ioe) {}
            } else {
                this.outputPumper.quit();
            }
            int result = this.child.waitFor();
            return result;
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.inerr != null) {
                    this.inerr.close();
                }
                if (this.output != null) {
                    this.output.close();
                }
                if (this.inputChannel != null) {
                    this.inputChannel.close();
                }
                if (this.inerrChannel != null) {
                    this.inerrChannel.close();
                }
                if (this.outputChannel != null) {
                    this.outputChannel.close();
                }
                POpenProcess pOpenProcess = this;
                synchronized (pOpenProcess) {
                    Pumper pumper;
                    if (this.inputPumper != null) {
                        pumper = this.inputPumper;
                        synchronized (pumper) {
                            this.inputPumper.quit();
                        }
                    }
                    if (this.inerrPumper != null) {
                        pumper = this.inerrPumper;
                        synchronized (pumper) {
                            this.inerrPumper.quit();
                        }
                    }
                    if (this.outputPumper != null) {
                        pumper = this.outputPumper;
                        synchronized (pumper) {
                            this.outputPumper.quit();
                        }
                    }
                    this.child.destroy();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private void prepareInput(Process child) {
            this.input = ShellLauncher.unwrapBufferedStream(child.getInputStream());
            this.inputChannel = this.input instanceof FileInputStream ? ((FileInputStream)this.input).getChannel() : null;
            this.inputPumper = null;
        }

        private void prepareInerr(Process child) {
            this.inerr = ShellLauncher.unwrapBufferedStream(child.getErrorStream());
            this.inerrChannel = this.inerr instanceof FileInputStream ? ((FileInputStream)this.inerr).getChannel() : null;
            this.inerrPumper = null;
        }

        private void prepareOutput(Process child) {
            this.output = ShellLauncher.unwrapBufferedStream(child.getOutputStream());
            this.outputChannel = this.output instanceof FileOutputStream ? ((FileOutputStream)this.output).getChannel() : null;
            this.outputPumper = null;
        }

        private void pumpInput(Process child, Ruby runtime2) {
            InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getInputStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime2.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inputPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inputPumper.start();
            this.input = null;
            this.inputChannel = null;
        }

        private void pumpInerr(Process child, Ruby runtime2) {
            InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getErrorStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime2.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inerrPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inerrPumper.start();
            this.inerr = null;
            this.inerrChannel = null;
        }
    }

    private static interface PidGetter {
        public long getPid(Process var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private final String[] argArray;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;
        private final PipedInputStream processOutput;
        private final PipedInputStream processError;
        private final PipedOutputStream processInput;
        private RubyInstanceConfig config;
        private Thread processThread;
        private int result;

        public ScriptThreadProcess(String[] argArray, String[] env, File dir) {
            this(argArray, env, dir, true);
        }

        public ScriptThreadProcess(String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            } else {
                this.processError = null;
                this.processOutput = null;
                this.processInput = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.result = new Main(this.config).run(this.argArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.config.getError());
                this.result = -1;
            }
            finally {
                this.config.getOutput().close();
                this.config.getError().close();
                try {
                    this.config.getInput().close();
                }
                catch (IOException ioe) {}
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException io2) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException io3) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

