/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.sun.codemodel.JType;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.jsonschema2pojo.GenerationConfig;

public class NameHelper {
    public static final String ILLEGAL_CHARACTER_REGEX = "[^0-9a-zA-Z_$]";
    private final GenerationConfig generationConfig;

    public NameHelper(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public String replaceIllegalCharacters(String name) {
        return name.replaceAll(ILLEGAL_CHARACTER_REGEX, "_");
    }

    public String normalizeName(String name) {
        if (Character.isDigit((name = this.capitalizeTrailingWords(name)).charAt(0))) {
            name = "_" + name;
        }
        return name;
    }

    public String capitalizeTrailingWords(String name) {
        char[] wordDelimiters = this.generationConfig.getPropertyWordDelimiters();
        if (StringUtils.containsAny((CharSequence)name, (char[])wordDelimiters)) {
            String capitalizedNodeName = WordUtils.capitalize((String)name, (char[])wordDelimiters);
            name = name.charAt(0) + capitalizedNodeName.substring(1);
            for (char c : wordDelimiters) {
                name = StringUtils.remove((String)name, (char)c);
            }
        }
        return name;
    }

    public String getPropertyName(String jsonFieldName) {
        jsonFieldName = this.replaceIllegalCharacters(jsonFieldName);
        if (SourceVersion.isKeyword(jsonFieldName = this.normalizeName(jsonFieldName))) {
            jsonFieldName = "_" + jsonFieldName;
        }
        if (SourceVersion.isKeyword(jsonFieldName)) {
            jsonFieldName = jsonFieldName + "_";
        }
        return jsonFieldName;
    }

    public String getSetterName(String propertyName) {
        propertyName = this.replaceIllegalCharacters(propertyName);
        String setterName = "set" + StringUtils.capitalize((String)this.capitalizeTrailingWords(propertyName));
        if (setterName.equals("setClass")) {
            setterName = "setClass_";
        }
        return setterName;
    }

    public String getGetterName(String propertyName, JType type) {
        String prefix = type.equals(type.owner()._ref(Boolean.TYPE)) ? "is" : "get";
        propertyName = this.replaceIllegalCharacters(propertyName);
        String getterName = prefix + StringUtils.capitalize((String)this.capitalizeTrailingWords(propertyName));
        if (getterName.equals("getClass")) {
            getterName = "getClass_";
        }
        return getterName;
    }
}

