/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import jakarta.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class MinimumMaximumRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    protected MinimumMaximumRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JsonNode parent, JFieldVar field, Schema currentSchema) {
        if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations() && this.isApplicableType(field)) {
            JAnnotationUse annotation;
            if (node.has("minimum")) {
                Class decimalMinClass = this.ruleFactory.getGenerationConfig().isUseJakartaValidation() ? jakarta.validation.constraints.DecimalMin.class : DecimalMin.class;
                annotation = field.annotate(decimalMinClass);
                annotation.param("value", node.get("minimum").asText());
            }
            if (node.has("maximum")) {
                Class decimalMaxClass = this.ruleFactory.getGenerationConfig().isUseJakartaValidation() ? DecimalMax.class : javax.validation.constraints.DecimalMax.class;
                annotation = field.annotate(decimalMaxClass);
                annotation.param("value", node.get("maximum").asText());
            }
        }
        return field;
    }

    private boolean isApplicableType(JFieldVar field) {
        try {
            Class<?> fieldClass = Class.forName(field.type().boxify().fullName());
            return String.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass) && !Float.class.isAssignableFrom(fieldClass) && !Double.class.isAssignableFrom(fieldClass);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

