/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ProjectClasspath {
    public ClassLoader getClassLoader(MavenProject project, final ClassLoader parent, Log log) throws DependencyResolutionRequiredException {
        List classpathElements = project.getCompileClasspathElements();
        final ArrayList<URL> classpathUrls = new ArrayList<URL>(classpathElements.size());
        for (String classpathElement : classpathElements) {
            try {
                log.debug((CharSequence)("Adding project artifact to classpath: " + classpathElement));
                classpathUrls.add(new File(classpathElement).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.debug((CharSequence)("Unable to use classpath entry as it could not be understood as a valid URL: " + classpathElement), (Throwable)e);
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), parent);
            }
        });
    }
}

