/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.list;

import java.util.ArrayList;
import java.util.Iterator;
import org.jtwig.exceptions.CalculationException;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.util.FunctionValueUtils;

public class SliceFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "slice";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.minimumNumberOfArguments(3).maximumNumberOfArguments(3);
        return this.slice(request, FunctionValueUtils.getNumber(request, 1).intValue(), FunctionValueUtils.getNumber(request, 2).intValue());
    }

    private Object slice(FunctionRequest request, int begin, int length) throws CalculationException {
        Object input = request.get(0);
        if (input instanceof String) {
            String value = (String)input;
            if (value.length() < begin) {
                return "";
            }
            return value.substring(begin, Math.min(value.length(), begin + length));
        }
        Iterator<Object> iterator = FunctionValueUtils.getCollection(request, 0).iterator();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= begin && i < begin + length) {
                list.add(iterator.next());
            } else {
                iterator.next();
            }
            ++i;
        }
        return list;
    }
}

