/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.resolver;

import com.google.common.base.Optional;
import java.lang.reflect.InvocationTargetException;
import org.jtwig.property.resolver.PropertyResolver;
import org.jtwig.property.resolver.request.PropertyResolveRequest;
import org.jtwig.property.strategy.method.ArgumentsConverter;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodPropertyResolver
implements PropertyResolver {
    private static final Logger logger = LoggerFactory.getLogger(MethodPropertyResolver.class);
    private final JavaMethod javaMethod;
    private final ArgumentsConverter argumentsConverter;

    public MethodPropertyResolver(JavaMethod javaMethod, ArgumentsConverter argumentsConverter) {
        this.javaMethod = javaMethod;
        this.argumentsConverter = argumentsConverter;
    }

    @Override
    public Optional<Value> resolve(PropertyResolveRequest request) {
        if (request.getContext() == null) {
            return Optional.absent();
        }
        Object[] arguments = request.getArguments().toArray();
        Optional<Object[]> convert = this.argumentsConverter.convert(this.javaMethod, arguments);
        if (convert.isPresent()) {
            try {
                return Optional.of((Object)new Value(this.javaMethod.invoke(request.getContext(), (Object[])convert.get())));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.debug("Unable to retrieve value from method {} with arguments {}", new Object[]{this.javaMethod, request.getArguments(), e});
                return Optional.absent();
            }
        }
        logger.debug("Cannot convert arguments provided {} to defined method arguments types {}.", (Object)arguments, (Object)this.javaMethod.arguments());
        return Optional.absent();
    }
}

