/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.strategy.method.convert;

import com.google.common.base.Optional;
import org.jtwig.property.strategy.method.argument.AssignableTypes;
import org.jtwig.property.strategy.method.argument.IsNativeType;
import org.jtwig.property.strategy.method.convert.Converter;
import org.jtwig.reflection.model.Value;

public class NativeTypeConverter
implements Converter {
    private final IsNativeType isNativeType;
    private final AssignableTypes assignableTypes;

    public NativeTypeConverter(IsNativeType isNativeType, AssignableTypes assignableTypes) {
        this.isNativeType = isNativeType;
        this.assignableTypes = assignableTypes;
    }

    @Override
    public Optional<Value> convert(Object value, Class type) {
        if (value != null) {
            if (this.assignableTypes.isAssignable(type, value.getClass())) {
                return Optional.of((Object)new Value(value));
            }
            return Optional.absent();
        }
        if (this.isNativeType.isNative(type)) {
            return Optional.absent();
        }
        return Optional.of((Object)new Value(null));
    }
}

