/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.resource.metadata;

import com.google.common.base.Optional;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.jtwig.resource.loader.ResourceLoader;
import org.jtwig.resource.metadata.ResourceMetadata;
import org.jtwig.resource.reference.ResourceReference;

public class ResourceResourceMetadata
implements ResourceMetadata {
    private final ResourceLoader resourceLoader;
    private final ResourceReference resourceReference;

    public ResourceResourceMetadata(ResourceLoader resourceLoader, ResourceReference resourceReference) {
        this.resourceLoader = resourceLoader;
        this.resourceReference = resourceReference;
    }

    @Override
    public boolean exists() {
        return this.resourceLoader.exists(this.resourceReference.getPath());
    }

    @Override
    public InputStream load() {
        return this.resourceLoader.load(this.resourceReference.getPath());
    }

    @Override
    public Optional<Charset> getCharset() {
        return this.resourceLoader.getCharset(this.resourceReference.getPath());
    }

    @Override
    public Optional<URL> toUrl() {
        return this.resourceLoader.toUrl(this.resourceReference.getPath());
    }

    public ResourceReference getResourceReference() {
        return this.resourceReference;
    }
}

