/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.resource.reference.path;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import org.jtwig.resource.reference.path.PathType;

public class PathTypeSupplier
implements Supplier<PathType> {
    public static final String OS_NAME = "os.name";
    public static final String WIN = "win";
    private static final PathTypeSupplier INSTANCE = new PathTypeSupplier(new Function<String, String>(){

        public String apply(String input) {
            return System.getProperty(input);
        }
    });
    private final PathType type;

    public static PathTypeSupplier pathTypeSupplier() {
        return INSTANCE;
    }

    PathTypeSupplier(Function<String, String> systemProperties) {
        String operatingSystem = ((String)systemProperties.apply((Object)OS_NAME)).toLowerCase();
        this.type = operatingSystem.contains(WIN) ? PathType.UNC : PathType.POSIX;
    }

    public PathType get() {
        return this.type;
    }
}

