/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvParserFactory;
import org.junit.jupiter.params.provider.CsvParsingException;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class CsvArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvSource> {
    private static final String LINE_SEPARATOR = "\n";
    private CsvSource annotation;
    private Set<String> nullValues;
    private CsvParser csvParser;

    CsvArgumentsProvider() {
    }

    @Override
    public void accept(CsvSource annotation) {
        this.annotation = annotation;
        this.nullValues = CollectionUtils.toSet((Object[])annotation.nullValues());
        this.csvParser = CsvParserFactory.createParserFor(annotation);
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        boolean textBlockDeclared = !this.annotation.textBlock().isEmpty();
        Preconditions.condition((boolean)(this.annotation.value().length > 0 ^ textBlockDeclared), () -> "@CsvSource must be declared with either `value` or `textBlock` but not both");
        return textBlockDeclared ? this.parseTextBlock() : this.parseValueArray();
    }

    private Stream<Arguments> parseTextBlock() {
        String textBlock = this.annotation.textBlock();
        boolean useHeadersInDisplayName = this.annotation.useHeadersInDisplayName();
        ArrayList<Arguments> argumentsList = new ArrayList<Arguments>();
        try {
            List<String[]> csvRecords = this.csvParser.parseAll(new StringReader(textBlock));
            String[] headers = useHeadersInDisplayName ? CsvArgumentsProvider.getHeaders(this.csvParser) : null;
            AtomicInteger index = new AtomicInteger(0);
            for (Object[] objectArray : csvRecords) {
                index.incrementAndGet();
                Preconditions.notNull((Object)objectArray, () -> "Record at index " + index + " contains invalid CSV: \"\"\"\n" + textBlock + "\n\"\"\"");
                argumentsList.add(CsvArgumentsProvider.processCsvRecord(objectArray, this.nullValues, useHeadersInDisplayName, headers));
            }
        }
        catch (Throwable throwable) {
            throw CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
        }
        return argumentsList.stream();
    }

    private Stream<Arguments> parseValueArray() {
        boolean useHeadersInDisplayName = this.annotation.useHeadersInDisplayName();
        ArrayList<Arguments> argumentsList = new ArrayList<Arguments>();
        try {
            String[] headers = null;
            AtomicInteger index = new AtomicInteger(0);
            for (String input : this.annotation.value()) {
                index.incrementAndGet();
                Object[] csvRecord = this.csvParser.parseLine(input + LINE_SEPARATOR);
                if (useHeadersInDisplayName && headers == null) {
                    headers = CsvArgumentsProvider.getHeaders(this.csvParser);
                }
                Preconditions.notNull((Object)csvRecord, () -> "Record at index " + index + " contains invalid CSV: \"" + input + "\"");
                argumentsList.add(CsvArgumentsProvider.processCsvRecord(csvRecord, this.nullValues, useHeadersInDisplayName, headers));
            }
        }
        catch (Throwable throwable) {
            throw CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
        }
        return argumentsList.stream();
    }

    static String[] getHeaders(CsvParser csvParser) {
        return (String[])Arrays.stream(csvParser.getContext().parsedHeaders()).map(String::trim).toArray(String[]::new);
    }

    static Arguments processCsvRecord(Object[] csvRecord, Set<String> nullValues, boolean useHeadersInDisplayName, String[] headers) {
        if (nullValues.isEmpty() && !useHeadersInDisplayName) {
            return Arguments.of(csvRecord);
        }
        Preconditions.condition((!useHeadersInDisplayName || csvRecord.length <= headers.length ? 1 : 0) != 0, () -> String.format("The number of columns (%d) exceeds the number of supplied headers (%d) in CSV record: %s", csvRecord.length, headers.length, Arrays.toString(csvRecord)));
        Object[] arguments = new Object[csvRecord.length];
        for (int i = 0; i < csvRecord.length; ++i) {
            Object column = csvRecord[i];
            if (nullValues.contains(column)) {
                column = null;
            }
            if (useHeadersInDisplayName) {
                column = Named.of((String)(headers[i] + " = " + column), (Object)column);
            }
            arguments[i] = column;
        }
        return Arguments.of(arguments);
    }

    static RuntimeException handleCsvException(Throwable throwable, Annotation annotation) {
        UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
        if (throwable instanceof PreconditionViolationException) {
            throw (PreconditionViolationException)throwable;
        }
        throw new CsvParsingException("Failed to parse CSV input configured via " + annotation, throwable);
    }
}

