/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.jfr;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import org.apiguardian.api.API;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.jfr.UniqueId;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.STABLE, since="1.11")
public class FlightRecordingExecutionListener
implements TestExecutionListener {
    private final AtomicReference<TestPlanExecutionEvent> testPlanExecutionEvent = new AtomicReference();
    private final Map<org.junit.platform.engine.UniqueId, TestExecutionEvent> testExecutionEvents = new ConcurrentHashMap<org.junit.platform.engine.UniqueId, TestExecutionEvent>();

    public void testPlanExecutionStarted(TestPlan plan) {
        TestPlanExecutionEvent event = new TestPlanExecutionEvent();
        event.containsTests = plan.containsTests();
        event.engineNames = plan.getRoots().stream().map(TestIdentifier::getDisplayName).collect(Collectors.joining(", "));
        this.testPlanExecutionEvent.set(event);
        event.begin();
    }

    public void testPlanExecutionFinished(TestPlan plan) {
        ((TestPlanExecutionEvent)this.testPlanExecutionEvent.getAndSet(null)).commit();
    }

    public void executionSkipped(TestIdentifier test, String reason) {
        SkippedTestEvent event = new SkippedTestEvent();
        event.initialize(test);
        event.reason = reason;
        event.commit();
    }

    public void executionStarted(TestIdentifier test) {
        TestExecutionEvent event = new TestExecutionEvent();
        this.testExecutionEvents.put(test.getUniqueIdObject(), event);
        event.initialize(test);
        event.begin();
    }

    public void executionFinished(TestIdentifier test, TestExecutionResult result) {
        Optional throwable = result.getThrowable();
        TestExecutionEvent event = this.testExecutionEvents.remove(test.getUniqueIdObject());
        event.end();
        event.result = result.getStatus().toString();
        event.exceptionClass = throwable.map(Object::getClass).orElse(null);
        event.exceptionMessage = throwable.map(Throwable::getMessage).orElse(null);
        event.commit();
    }

    public void reportingEntryPublished(TestIdentifier test, ReportEntry reportEntry) {
        for (Map.Entry entry : reportEntry.getKeyValuePairs().entrySet()) {
            ReportEntryEvent event = new ReportEntryEvent();
            event.uniqueId = test.getUniqueId();
            event.key = (String)entry.getKey();
            event.value = (String)entry.getValue();
            event.commit();
        }
    }

    @Label(value="Report Entry")
    @Name(value="org.junit.ReportEntry")
    static class ReportEntryEvent
    extends ExecutionEvent {
        @UniqueId
        @Label(value="Unique Id")
        String uniqueId;
        @Label(value="Key")
        String key;
        @Label(value="Value")
        String value;

        ReportEntryEvent() {
        }
    }

    @Label(value="Test")
    @Name(value="org.junit.TestExecution")
    static class TestExecutionEvent
    extends TestEvent {
        @Label(value="Result")
        String result;
        @Label(value="Exception Class")
        Class<?> exceptionClass;
        @Label(value="Exception Message")
        String exceptionMessage;

        TestExecutionEvent() {
        }
    }

    @Label(value="Skipped Test")
    @Name(value="org.junit.SkippedTest")
    static class SkippedTestEvent
    extends TestEvent {
        @Label(value="Reason")
        String reason;

        SkippedTestEvent() {
        }
    }

    static abstract class TestEvent
    extends ExecutionEvent {
        @UniqueId
        @Label(value="Unique Id")
        String uniqueId;
        @Label(value="Display Name")
        String displayName;
        @Label(value="Tags")
        String tags;
        @Label(value="Type")
        String type;

        TestEvent() {
        }

        void initialize(TestIdentifier test) {
            this.uniqueId = test.getUniqueId();
            this.displayName = test.getDisplayName();
            this.tags = test.getTags().isEmpty() ? null : test.getTags().toString();
            this.type = test.getType().name();
        }
    }

    @Label(value="Test Execution")
    @Name(value="org.junit.TestPlanExecution")
    static class TestPlanExecutionEvent
    extends ExecutionEvent {
        @Label(value="Contains Tests")
        boolean containsTests;
        @Label(value="Engine Names")
        String engineNames;

        TestPlanExecutionEvent() {
        }
    }

    @Category(value={"JUnit", "Execution"})
    @StackTrace(value=false)
    static abstract class ExecutionEvent
    extends Event {
        ExecutionEvent() {
        }
    }
}

