/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.igd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.model.types.UDAServiceType;
import org.jupnp.registry.DefaultRegistryListener;
import org.jupnp.registry.Registry;
import org.jupnp.support.igd.callback.PortMappingAdd;
import org.jupnp.support.igd.callback.PortMappingDelete;
import org.jupnp.support.model.PortMapping;

public class PortMappingListener
extends DefaultRegistryListener {
    private final Logger logger = Logger.getLogger(PortMappingListener.class.getName());
    public static final DeviceType IGD_DEVICE_TYPE = new UDADeviceType("InternetGatewayDevice", 1);
    public static final DeviceType CONNECTION_DEVICE_TYPE = new UDADeviceType("WANConnectionDevice", 1);
    public static final ServiceType IP_SERVICE_TYPE = new UDAServiceType("WANIPConnection", 1);
    public static final ServiceType PPP_SERVICE_TYPE = new UDAServiceType("WANPPPConnection", 1);
    protected PortMapping[] portMappings;
    protected Map<Service<?, ?>, List<PortMapping>> activePortMappings = new HashMap();

    public PortMappingListener(PortMapping portMapping) {
        this(new PortMapping[]{portMapping});
    }

    public PortMappingListener(PortMapping[] portMappings) {
        this.portMappings = portMappings;
    }

    public synchronized void deviceAdded(Registry registry, Device device) {
        Service<?, ?> connectionService = this.discoverConnectionService(device);
        if (connectionService == null) {
            return;
        }
        this.logger.fine("Activating port mappings on: " + connectionService);
        final ArrayList activeForService = new ArrayList();
        PortMapping[] portMappingArray = this.portMappings;
        int n = this.portMappings.length;
        int n2 = 0;
        while (n2 < n) {
            final PortMapping pm = portMappingArray[n2];
            new PortMappingAdd(connectionService, registry.getUpnpService().getControlPoint(), pm){

                public void success(ActionInvocation invocation) {
                    PortMappingListener.this.logger.fine("Port mapping added: " + pm);
                    activeForService.add(pm);
                }

                public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                    PortMappingListener.this.handleFailureMessage("Failed to add port mapping: " + pm);
                    PortMappingListener.this.handleFailureMessage("Reason: " + defaultMsg);
                }
            }.run();
            ++n2;
        }
        this.activePortMappings.put(connectionService, activeForService);
    }

    public synchronized void deviceRemoved(Registry registry, Device device) {
        Service[] serviceArray = device.findServices();
        int n = serviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            Iterator<Map.Entry<Service<?, ?>, List<PortMapping>>> it = this.activePortMappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Service<?, ?>, List<PortMapping>> activeEntry = it.next();
                if (!activeEntry.getKey().equals((Object)service)) continue;
                if (activeEntry.getValue().size() > 0) {
                    this.handleFailureMessage("Device disappeared, couldn't delete port mappings: " + activeEntry.getValue().size());
                }
                it.remove();
            }
            ++n2;
        }
    }

    public synchronized void beforeShutdown(Registry registry) {
        for (Map.Entry<Service<?, ?>, List<PortMapping>> activeEntry : this.activePortMappings.entrySet()) {
            final Iterator<PortMapping> it = activeEntry.getValue().iterator();
            while (it.hasNext()) {
                final PortMapping pm = it.next();
                this.logger.fine("Trying to delete port mapping on IGD: " + pm);
                new PortMappingDelete(activeEntry.getKey(), registry.getUpnpService().getControlPoint(), pm){

                    public void success(ActionInvocation invocation) {
                        PortMappingListener.this.logger.fine("Port mapping deleted: " + pm);
                        it.remove();
                    }

                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                        PortMappingListener.this.handleFailureMessage("Failed to delete port mapping: " + pm);
                        PortMappingListener.this.handleFailureMessage("Reason: " + defaultMsg);
                    }
                }.run();
            }
        }
    }

    protected Service<?, ?> discoverConnectionService(Device<?, ?, ?> device) {
        if (!device.getType().equals((Object)IGD_DEVICE_TYPE)) {
            return null;
        }
        Device[] connectionDevices = device.findDevices(CONNECTION_DEVICE_TYPE);
        if (connectionDevices.length == 0) {
            this.logger.fine("IGD doesn't support '" + CONNECTION_DEVICE_TYPE + "': " + device);
            return null;
        }
        Device connectionDevice = connectionDevices[0];
        this.logger.fine("Using first discovered WAN connection device: " + connectionDevice);
        Service ipConnectionService = connectionDevice.findService(IP_SERVICE_TYPE);
        Service pppConnectionService = connectionDevice.findService(PPP_SERVICE_TYPE);
        if (ipConnectionService == null && pppConnectionService == null) {
            this.logger.fine("IGD doesn't support IP or PPP WAN connection service: " + device);
        }
        return ipConnectionService != null ? ipConnectionService : pppConnectionService;
    }

    protected void handleFailureMessage(String s) {
        this.logger.warning(s);
    }
}

