/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.lastchange;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.lastchange.EventedValue;
import org.jupnp.support.lastchange.InstanceID;

public class Event {
    protected List<InstanceID> instanceIDs = new ArrayList<InstanceID>();

    public Event() {
    }

    public Event(List<InstanceID> instanceIDs) {
        this.instanceIDs = instanceIDs;
    }

    public List<InstanceID> getInstanceIDs() {
        return this.instanceIDs;
    }

    public InstanceID getInstanceID(UnsignedIntegerFourBytes id) {
        for (InstanceID instanceID : this.instanceIDs) {
            if (!instanceID.getId().equals((Object)id)) continue;
            return instanceID;
        }
        return null;
    }

    public void clear() {
        this.instanceIDs = new ArrayList<InstanceID>();
    }

    public void setEventedValue(UnsignedIntegerFourBytes id, EventedValue<?> ev) {
        InstanceID instanceID = null;
        for (InstanceID i : this.getInstanceIDs()) {
            if (!i.getId().equals((Object)id)) continue;
            instanceID = i;
        }
        if (instanceID == null) {
            instanceID = new InstanceID(id);
            this.getInstanceIDs().add(instanceID);
        }
        Iterator<EventedValue<?>> it = instanceID.getValues().iterator();
        while (it.hasNext()) {
            EventedValue<?> existingEv = it.next();
            if (!existingEv.getClass().equals(ev.getClass())) continue;
            it.remove();
        }
        instanceID.getValues().add(ev);
    }

    public <EV extends EventedValue<?>> EV getEventedValue(UnsignedIntegerFourBytes id, Class<EV> type) {
        for (InstanceID instanceID : this.getInstanceIDs()) {
            if (!instanceID.getId().equals((Object)id)) continue;
            for (EventedValue<?> eventedValue : instanceID.getValues()) {
                if (!eventedValue.getClass().equals(type)) continue;
                return (EV)eventedValue;
            }
        }
        return null;
    }

    public boolean hasChanges() {
        for (InstanceID instanceID : this.instanceIDs) {
            if (instanceID.getValues().size() <= 0) continue;
            return true;
        }
        return false;
    }
}

