/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import org.jupnp.model.ServiceReference;
import org.jupnp.support.model.ProtocolInfo;

public class ConnectionInfo {
    protected final int connectionID;
    protected final int rcsID;
    protected final int avTransportID;
    protected final ProtocolInfo protocolInfo;
    protected final ServiceReference peerConnectionManager;
    protected final int peerConnectionID;
    protected final Direction direction;
    protected Status connectionStatus = Status.Unknown;

    public ConnectionInfo() {
        this(0, 0, 0, null, null, -1, Direction.Input, Status.Unknown);
    }

    public ConnectionInfo(int connectionID, int rcsID, int avTransportID, ProtocolInfo protocolInfo, ServiceReference peerConnectionManager, int peerConnectionID, Direction direction, Status connectionStatus) {
        this.connectionID = connectionID;
        this.rcsID = rcsID;
        this.avTransportID = avTransportID;
        this.protocolInfo = protocolInfo;
        this.peerConnectionManager = peerConnectionManager;
        this.peerConnectionID = peerConnectionID;
        this.direction = direction;
        this.connectionStatus = connectionStatus;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public int getRcsID() {
        return this.rcsID;
    }

    public int getAvTransportID() {
        return this.avTransportID;
    }

    public ProtocolInfo getProtocolInfo() {
        return this.protocolInfo;
    }

    public ServiceReference getPeerConnectionManager() {
        return this.peerConnectionManager;
    }

    public int getPeerConnectionID() {
        return this.peerConnectionID;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public synchronized Status getConnectionStatus() {
        return this.connectionStatus;
    }

    public synchronized void setConnectionStatus(Status connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        if (this.avTransportID != that.avTransportID) {
            return false;
        }
        if (this.connectionID != that.connectionID) {
            return false;
        }
        if (this.peerConnectionID != that.peerConnectionID) {
            return false;
        }
        if (this.rcsID != that.rcsID) {
            return false;
        }
        if (this.connectionStatus != that.connectionStatus) {
            return false;
        }
        if (this.direction != that.direction) {
            return false;
        }
        if (this.peerConnectionManager != null ? !this.peerConnectionManager.equals((Object)that.peerConnectionManager) : that.peerConnectionManager != null) {
            return false;
        }
        return !(this.protocolInfo != null ? !this.protocolInfo.equals(that.protocolInfo) : that.protocolInfo != null);
    }

    public int hashCode() {
        int result = this.connectionID;
        result = 31 * result + this.rcsID;
        result = 31 * result + this.avTransportID;
        result = 31 * result + (this.protocolInfo != null ? this.protocolInfo.hashCode() : 0);
        result = 31 * result + (this.peerConnectionManager != null ? this.peerConnectionManager.hashCode() : 0);
        result = 31 * result + this.peerConnectionID;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.connectionStatus.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") ID: " + this.getConnectionID() + ", Status: " + (Object)((Object)this.getConnectionStatus());
    }

    public static enum Direction {
        Output,
        Input;


        public Direction getOpposite() {
            return this.equals((Object)Output) ? Input : Output;
        }
    }

    public static enum Status {
        OK,
        ContentFormatMismatch,
        InsufficientBandwidth,
        UnreliableChannel,
        Unknown;

    }
}

