/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jupnp.support.model.DIDLAttribute;
import org.jupnp.support.model.DescMeta;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.WriteStatus;
import org.w3c.dom.Element;

public abstract class DIDLObject {
    protected String id;
    protected String parentID;
    protected String title;
    protected String creator;
    protected boolean restricted = true;
    protected WriteStatus writeStatus;
    protected Class clazz;
    protected List<Res> resources = new ArrayList<Res>();
    protected List<Property<?>> properties = new ArrayList();
    protected List<DescMeta<?>> descMetadata = new ArrayList();

    protected DIDLObject() {
    }

    protected DIDLObject(DIDLObject other) {
        this(other.getId(), other.getParentID(), other.getTitle(), other.getCreator(), other.isRestricted(), other.getWriteStatus(), other.getClazz(), other.getResources(), other.getProperties(), other.getDescMetadata());
    }

    protected DIDLObject(String id, String parentID, String title, String creator, boolean restricted, WriteStatus writeStatus, Class clazz, List<Res> resources, List<Property<?>> properties, List<DescMeta<?>> descMetadata) {
        this.id = id;
        this.parentID = parentID;
        this.title = title;
        this.creator = creator;
        this.restricted = restricted;
        this.writeStatus = writeStatus;
        this.clazz = clazz;
        this.resources = resources;
        this.properties = properties;
        this.descMetadata = descMetadata;
    }

    public String getId() {
        return this.id;
    }

    public DIDLObject setId(String id) {
        this.id = id;
        return this;
    }

    public String getParentID() {
        return this.parentID;
    }

    public DIDLObject setParentID(String parentID) {
        this.parentID = parentID;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public DIDLObject setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public DIDLObject setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public DIDLObject setRestricted(boolean restricted) {
        this.restricted = restricted;
        return this;
    }

    public WriteStatus getWriteStatus() {
        return this.writeStatus;
    }

    public DIDLObject setWriteStatus(WriteStatus writeStatus) {
        this.writeStatus = writeStatus;
        return this;
    }

    public Res getFirstResource() {
        return this.getResources().isEmpty() ? this.getResources().get(0) : null;
    }

    public List<Res> getResources() {
        return this.resources;
    }

    public DIDLObject setResources(List<Res> resources) {
        this.resources = resources;
        return this;
    }

    public DIDLObject addResource(Res resource) {
        this.getResources().add(resource);
        return this;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public DIDLObject setClazz(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public List<Property<?>> getProperties() {
        return this.properties;
    }

    public DIDLObject setProperties(List<Property<?>> properties) {
        this.properties = properties;
        return this;
    }

    public DIDLObject addProperty(Property property) {
        if (property == null) {
            return this;
        }
        this.getProperties().add(property);
        return this;
    }

    public DIDLObject replaceFirstProperty(Property<?> property) {
        if (property == null) {
            return this;
        }
        Iterator<Property<?>> it = this.getProperties().iterator();
        while (it.hasNext()) {
            Property<?> p = it.next();
            if (!p.getClass().isAssignableFrom(property.getClass())) continue;
            it.remove();
        }
        this.addProperty(property);
        return this;
    }

    public DIDLObject replaceProperties(java.lang.Class<? extends Property<?>> propertyClass, Property<?>[] properties) {
        if (properties.length == 0) {
            return this;
        }
        this.removeProperties(propertyClass);
        return this.addProperties(properties);
    }

    public DIDLObject addProperties(Property<?>[] properties) {
        if (properties == null) {
            return this;
        }
        Property<?>[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property<?> property = propertyArray[n2];
            this.addProperty(property);
            ++n2;
        }
        return this;
    }

    public DIDLObject removeProperties(java.lang.Class<? extends Property<?>> propertyClass) {
        Iterator<Property<?>> it = this.getProperties().iterator();
        while (it.hasNext()) {
            Property<?> property = it.next();
            if (!propertyClass.isInstance(property)) continue;
            it.remove();
        }
        return this;
    }

    public boolean hasProperty(java.lang.Class<? extends Property<?>> propertyClass) {
        for (Property<?> property : this.getProperties()) {
            if (!propertyClass.isInstance(property)) continue;
            return true;
        }
        return false;
    }

    public <V> Property<V> getFirstProperty(java.lang.Class<? extends Property<V>> propertyClass) {
        for (Property<?> property : this.getProperties()) {
            if (!propertyClass.isInstance(property)) continue;
            return property;
        }
        return null;
    }

    public <V> Property<V> getLastProperty(java.lang.Class<? extends Property<V>> propertyClass) {
        Property<?> found = null;
        for (Property<?> property : this.getProperties()) {
            if (!propertyClass.isInstance(property)) continue;
            found = property;
        }
        return found;
    }

    public <V> Property<V>[] getProperties(java.lang.Class<? extends Property<V>> propertyClass) {
        ArrayList list = new ArrayList();
        for (Property<?> property : this.getProperties()) {
            if (!propertyClass.isInstance(property)) continue;
            list.add(property);
        }
        return list.toArray(new Property[list.size()]);
    }

    public <V> Property<V>[] getPropertiesByNamespace(java.lang.Class<? extends Property.NAMESPACE> namespace) {
        ArrayList list = new ArrayList();
        for (Property<?> property : this.getProperties()) {
            if (!namespace.isInstance(property)) continue;
            list.add(property);
        }
        return list.toArray(new Property[list.size()]);
    }

    public <V> V getFirstPropertyValue(java.lang.Class<? extends Property<V>> propertyClass) {
        Property<V> prop = this.getFirstProperty(propertyClass);
        return prop == null ? null : (V)prop.getValue();
    }

    public <V> List<V> getPropertyValues(java.lang.Class<? extends Property<V>> propertyClass) {
        ArrayList<V> list = new ArrayList<V>();
        Property<V>[] propertyArray = this.getProperties(propertyClass);
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property<V> property = propertyArray[n2];
            list.add(property.getValue());
            ++n2;
        }
        return list;
    }

    public List<DescMeta<?>> getDescMetadata() {
        return this.descMetadata;
    }

    public void setDescMetadata(List<DescMeta<?>> descMetadata) {
        this.descMetadata = descMetadata;
    }

    public DIDLObject addDescMetadata(DescMeta<?> descMetadata) {
        this.getDescMetadata().add(descMetadata);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DIDLObject that = (DIDLObject)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class Class {
        protected String value;
        protected String friendlyName;
        protected boolean includeDerived;

        public Class() {
        }

        public Class(String value) {
            this.value = value;
        }

        public Class(String value, String friendlyName) {
            this.value = value;
            this.friendlyName = friendlyName;
        }

        public Class(String value, String friendlyName, boolean includeDerived) {
            this.value = value;
            this.friendlyName = friendlyName;
            this.includeDerived = includeDerived;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public boolean isIncludeDerived() {
            return this.includeDerived;
        }

        public void setIncludeDerived(boolean includeDerived) {
            this.includeDerived = includeDerived;
        }

        public boolean equals(DIDLObject instance) {
            return this.getValue().equals(instance.getClazz().getValue());
        }
    }

    public static abstract class Property<V> {
        private V value;
        private final String descriptorName;
        private final List<Property<DIDLAttribute>> attributes = new ArrayList<Property<DIDLAttribute>>();

        protected Property() {
            this(null, null);
        }

        protected Property(String descriptorName) {
            this(null, descriptorName);
        }

        protected Property(V value, String descriptorName) {
            this.value = value;
            this.descriptorName = descriptorName == null ? this.getClass().getSimpleName().toLowerCase(Locale.ROOT).replace("didlobject$property$upnp$", "") : descriptorName;
        }

        protected Property(V value, String descriptorName, List<Property<DIDLAttribute>> attributes) {
            this.value = value;
            this.descriptorName = descriptorName == null ? this.getClass().getSimpleName().toLowerCase(Locale.ROOT).replace("didlobject$property$upnp$", "") : descriptorName;
            this.attributes.addAll(attributes);
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String getDescriptorName() {
            return this.descriptorName;
        }

        public void setOnElement(Element element) {
            element.setTextContent(this.toString());
            for (Property<DIDLAttribute> attr : this.attributes) {
                element.setAttributeNS(attr.getValue().getNamespaceURI(), String.valueOf(attr.getValue().getPrefix()) + ':' + attr.getDescriptorName(), attr.getValue().getValue());
            }
        }

        public void addAttribute(Property<DIDLAttribute> attr) {
            this.attributes.add(attr);
        }

        public void removeAttribute(Property<DIDLAttribute> attr) {
            this.attributes.remove(attr);
        }

        public void removeAttribute(String descriptorName) {
            for (Property<DIDLAttribute> attr : this.attributes) {
                if (!attr.getDescriptorName().equals(descriptorName)) continue;
                this.removeAttribute(attr);
                break;
            }
        }

        public Property<DIDLAttribute> getAttribute(String descriptorName) {
            for (Property<DIDLAttribute> attr : this.attributes) {
                if (!attr.getDescriptorName().equals(descriptorName)) continue;
                return attr;
            }
            return null;
        }

        public String toString() {
            return this.getValue() != null ? this.getValue().toString() : "";
        }

        public static class DC {

            public static class CONTRIBUTOR
            extends Property<Person>
            implements NAMESPACE {
                public CONTRIBUTOR() {
                }

                public CONTRIBUTOR(Person value) {
                    super(value, null);
                }
            }

            public static class DATE
            extends Property<String>
            implements NAMESPACE {
                public DATE() {
                }

                public DATE(String value) {
                    super(value, null);
                }
            }

            public static class DESCRIPTION
            extends Property<String>
            implements NAMESPACE {
                public DESCRIPTION() {
                }

                public DESCRIPTION(String value) {
                    super(value, null);
                }
            }

            public static class LANGUAGE
            extends Property<String>
            implements NAMESPACE {
                public LANGUAGE() {
                }

                public LANGUAGE(String value) {
                    super(value, null);
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "http://purl.org/dc/elements/1.1/";
            }

            public static class PUBLISHER
            extends Property<Person>
            implements NAMESPACE {
                public PUBLISHER() {
                }

                public PUBLISHER(Person value) {
                    super(value, null);
                }
            }

            public static class RELATION
            extends Property<URI>
            implements NAMESPACE {
                public RELATION() {
                }

                public RELATION(URI value) {
                    super(value, null);
                }
            }

            public static class RIGHTS
            extends Property<String>
            implements NAMESPACE {
                public RIGHTS() {
                }

                public RIGHTS(String value) {
                    super(value, null);
                }
            }
        }

        public static abstract class DLNA {

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "urn:schemas-dlna-org:metadata-1-0/";
            }

            public static class PROFILE_ID
            extends Property<DIDLAttribute>
            implements NAMESPACE {
                public PROFILE_ID() {
                    this((DIDLAttribute)null);
                }

                public PROFILE_ID(DIDLAttribute value) {
                    super(value, "profileID");
                }
            }
        }

        public static interface NAMESPACE {
        }

        public static class PropertyPersonWithRole
        extends Property<PersonWithRole> {
            public PropertyPersonWithRole() {
            }

            public PropertyPersonWithRole(String descriptorName) {
                super(descriptorName);
            }

            public PropertyPersonWithRole(PersonWithRole value, String descriptorName) {
                super(value, descriptorName);
            }

            @Override
            public void setOnElement(Element element) {
                if (this.getValue() != null) {
                    ((PersonWithRole)this.getValue()).setOnElement(element);
                }
            }
        }

        public static abstract class SEC {

            public static class CAPTIONINFO
            extends Property<URI>
            implements NAMESPACE {
                public CAPTIONINFO() {
                    this((URI)null);
                }

                public CAPTIONINFO(URI value) {
                    super(value, "CaptionInfo");
                }

                public CAPTIONINFO(URI value, List<Property<DIDLAttribute>> attributes) {
                    super(value, "CaptionInfo", attributes);
                }
            }

            public static class CAPTIONINFOEX
            extends Property<URI>
            implements NAMESPACE {
                public CAPTIONINFOEX() {
                    this((URI)null);
                }

                public CAPTIONINFOEX(URI value) {
                    super(value, "CaptionInfoEx");
                }

                public CAPTIONINFOEX(URI value, List<Property<DIDLAttribute>> attributes) {
                    super(value, "CaptionInfoEx", attributes);
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "http://www.sec.co.kr/";
            }

            public static class TYPE
            extends Property<DIDLAttribute>
            implements NAMESPACE {
                public TYPE() {
                    this((DIDLAttribute)null);
                }

                public TYPE(DIDLAttribute value) {
                    super(value, "type");
                }
            }
        }

        public static abstract class UPNP {

            public static class ACTOR
            extends PropertyPersonWithRole
            implements NAMESPACE {
                public ACTOR() {
                }

                public ACTOR(PersonWithRole value) {
                    super(value, (String)null);
                }
            }

            public static class ALBUM
            extends Property<String>
            implements NAMESPACE {
                public ALBUM() {
                }

                public ALBUM(String value) {
                    super(value, null);
                }
            }

            public static class ALBUM_ART_URI
            extends Property<URI>
            implements NAMESPACE {
                public ALBUM_ART_URI() {
                    this((URI)null);
                }

                public ALBUM_ART_URI(URI value) {
                    super(value, "albumArtURI");
                }

                public ALBUM_ART_URI(URI value, List<Property<DIDLAttribute>> attributes) {
                    super(value, "albumArtURI", attributes);
                }
            }

            public static class ARTIST
            extends PropertyPersonWithRole
            implements NAMESPACE {
                public ARTIST() {
                }

                public ARTIST(PersonWithRole value) {
                    super(value, (String)null);
                }
            }

            public static class ARTIST_DISCO_URI
            extends Property<URI>
            implements NAMESPACE {
                public ARTIST_DISCO_URI() {
                    this((URI)null);
                }

                public ARTIST_DISCO_URI(URI value) {
                    super(value, "artistDiscographyURI");
                }
            }

            public static class AUTHOR
            extends PropertyPersonWithRole
            implements NAMESPACE {
                public AUTHOR() {
                }

                public AUTHOR(PersonWithRole value) {
                    super(value, (String)null);
                }
            }

            public static class CHANNEL_NAME
            extends Property<String>
            implements NAMESPACE {
                public CHANNEL_NAME() {
                    this(null);
                }

                public CHANNEL_NAME(String value) {
                    super(value, "channelName");
                }
            }

            public static class CHANNEL_NR
            extends Property<Integer>
            implements NAMESPACE {
                public CHANNEL_NR() {
                    this((Integer)null);
                }

                public CHANNEL_NR(Integer value) {
                    super(value, "channelNr");
                }
            }

            public static class DIRECTOR
            extends Property<Person>
            implements NAMESPACE {
                public DIRECTOR() {
                }

                public DIRECTOR(Person value) {
                    super(value, null);
                }
            }

            public static class DVD_REGION_CODE
            extends Property<Integer>
            implements NAMESPACE {
                public DVD_REGION_CODE() {
                    this((Integer)null);
                }

                public DVD_REGION_CODE(Integer value) {
                    super(value, "DVDRegionCode");
                }
            }

            public static class GENRE
            extends Property<String>
            implements NAMESPACE {
                public GENRE() {
                }

                public GENRE(String value) {
                    super(value, null);
                }
            }

            public static class ICON
            extends Property<URI>
            implements NAMESPACE {
                public ICON() {
                    this((URI)null);
                }

                public ICON(URI value) {
                    super(value, "icon");
                }
            }

            public static class LONG_DESCRIPTION
            extends Property<String>
            implements NAMESPACE {
                public LONG_DESCRIPTION() {
                    this(null);
                }

                public LONG_DESCRIPTION(String value) {
                    super(value, "longDescription");
                }
            }

            public static class LYRICS_URI
            extends Property<URI>
            implements NAMESPACE {
                public LYRICS_URI() {
                    this((URI)null);
                }

                public LYRICS_URI(URI value) {
                    super(value, "lyricsURI");
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "urn:schemas-upnp-org:metadata-1-0/upnp/";
            }

            public static class ORIGINAL_TRACK_NUMBER
            extends Property<Integer>
            implements NAMESPACE {
                public ORIGINAL_TRACK_NUMBER() {
                    this((Integer)null);
                }

                public ORIGINAL_TRACK_NUMBER(Integer value) {
                    super(value, "originalTrackNumber");
                }
            }

            public static class PLAYLIST
            extends Property<String>
            implements NAMESPACE {
                public PLAYLIST() {
                }

                public PLAYLIST(String value) {
                    super(value, null);
                }
            }

            public static class PRODUCER
            extends Property<Person>
            implements NAMESPACE {
                public PRODUCER() {
                }

                public PRODUCER(Person value) {
                    super(value, null);
                }
            }

            public static class RADIO_BAND
            extends Property<String>
            implements NAMESPACE {
                public RADIO_BAND() {
                    this(null);
                }

                public RADIO_BAND(String value) {
                    super(value, "radioBand");
                }
            }

            public static class RADIO_CALL_SIGN
            extends Property<String>
            implements NAMESPACE {
                public RADIO_CALL_SIGN() {
                    this(null);
                }

                public RADIO_CALL_SIGN(String value) {
                    super(value, "radioCallSign");
                }
            }

            public static class RADIO_STATION_ID
            extends Property<String>
            implements NAMESPACE {
                public RADIO_STATION_ID() {
                    this(null);
                }

                public RADIO_STATION_ID(String value) {
                    super(value, "radioStationID");
                }
            }

            public static class RATING
            extends Property<String>
            implements NAMESPACE {
                public RATING() {
                }

                public RATING(String value) {
                    super(value, null);
                }
            }

            public static class REGION
            extends Property<String>
            implements NAMESPACE {
                public REGION() {
                }

                public REGION(String value) {
                    super(value, null);
                }
            }

            public static class SCHEDULED_END_TIME
            extends Property<String>
            implements NAMESPACE {
                public SCHEDULED_END_TIME() {
                    this(null);
                }

                public SCHEDULED_END_TIME(String value) {
                    super(value, "scheduledEndTime");
                }
            }

            public static class SCHEDULED_START_TIME
            extends Property<String>
            implements NAMESPACE {
                public SCHEDULED_START_TIME() {
                    this(null);
                }

                public SCHEDULED_START_TIME(String value) {
                    super(value, "scheduledStartTime");
                }
            }

            public static class STORAGE_FREE
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_FREE() {
                    this((Long)null);
                }

                public STORAGE_FREE(Long value) {
                    super(value, "storageFree");
                }
            }

            public static class STORAGE_MAX_PARTITION
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_MAX_PARTITION() {
                    this((Long)null);
                }

                public STORAGE_MAX_PARTITION(Long value) {
                    super(value, "storageMaxPartition");
                }
            }

            public static class STORAGE_MEDIUM
            extends Property<StorageMedium>
            implements NAMESPACE {
                public STORAGE_MEDIUM() {
                    this((StorageMedium)null);
                }

                public STORAGE_MEDIUM(StorageMedium value) {
                    super(value, "storageMedium");
                }
            }

            public static class STORAGE_TOTAL
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_TOTAL() {
                    this((Long)null);
                }

                public STORAGE_TOTAL(Long value) {
                    super(value, "storageTotal");
                }
            }

            public static class STORAGE_USED
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_USED() {
                    this((Long)null);
                }

                public STORAGE_USED(Long value) {
                    super(value, "storageUsed");
                }
            }

            public static class TOC
            extends Property<String>
            implements NAMESPACE {
                public TOC() {
                }

                public TOC(String value) {
                    super(value, null);
                }
            }

            public static class USER_ANNOTATION
            extends Property<String>
            implements NAMESPACE {
                public USER_ANNOTATION() {
                    this(null);
                }

                public USER_ANNOTATION(String value) {
                    super(value, "userAnnotation");
                }
            }
        }
    }
}

