/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.ArrayList;

public class SortCriterion {
    protected final boolean ascending;
    protected final String propertyName;

    public SortCriterion(boolean ascending, String propertyName) {
        this.ascending = ascending;
        this.propertyName = propertyName;
    }

    public SortCriterion(String criterion) {
        this(criterion.startsWith("+"), criterion.substring(1));
        if (!criterion.startsWith("-") && !criterion.startsWith("+")) {
            throw new IllegalArgumentException("Missing sort prefix +/- on criterion: " + criterion);
        }
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public static SortCriterion[] valueOf(String s) {
        String[] criteria;
        if (s == null || s.length() == 0) {
            return new SortCriterion[0];
        }
        ArrayList<SortCriterion> list = new ArrayList<SortCriterion>();
        String[] stringArray = criteria = s.split(",");
        int n = criteria.length;
        int n2 = 0;
        while (n2 < n) {
            String criterion = stringArray[n2];
            list.add(new SortCriterion(criterion.trim()));
            ++n2;
        }
        return list.toArray(new SortCriterion[list.size()]);
    }

    public static String toString(SortCriterion[] criteria) {
        if (criteria == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SortCriterion[] sortCriterionArray = criteria;
        int n = criteria.length;
        int n2 = 0;
        while (n2 < n) {
            SortCriterion sortCriterion = sortCriterionArray[n2];
            sb.append(sortCriterion.toString()).append(",");
            ++n2;
        }
        if (sb.toString().endsWith(",")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ascending ? "+" : "-");
        sb.append(this.propertyName);
        return sb.toString();
    }
}

