/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message.header;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.support.model.dlna.message.header.AvailableRangeHeader;
import org.jupnp.support.model.dlna.message.header.AvailableSeekRangeHeader;
import org.jupnp.support.model.dlna.message.header.BufferBytesHeader;
import org.jupnp.support.model.dlna.message.header.BufferInfoHeader;
import org.jupnp.support.model.dlna.message.header.ContentFeaturesHeader;
import org.jupnp.support.model.dlna.message.header.EventTypeHeader;
import org.jupnp.support.model.dlna.message.header.FriendlyNameHeader;
import org.jupnp.support.model.dlna.message.header.GetAvailableSeekRangeHeader;
import org.jupnp.support.model.dlna.message.header.GetContentFeaturesHeader;
import org.jupnp.support.model.dlna.message.header.MaxPrateHeader;
import org.jupnp.support.model.dlna.message.header.PeerManagerHeader;
import org.jupnp.support.model.dlna.message.header.PlaySpeedHeader;
import org.jupnp.support.model.dlna.message.header.PragmaHeader;
import org.jupnp.support.model.dlna.message.header.RealTimeInfoHeader;
import org.jupnp.support.model.dlna.message.header.SCIDHeader;
import org.jupnp.support.model.dlna.message.header.ScmsFlagHeader;
import org.jupnp.support.model.dlna.message.header.SupportedHeader;
import org.jupnp.support.model.dlna.message.header.TimeSeekRangeHeader;
import org.jupnp.support.model.dlna.message.header.TransferModeHeader;
import org.jupnp.support.model.dlna.message.header.WCTHeader;
import org.jupnp.util.Exceptions;

public abstract class DLNAHeader<T>
extends UpnpHeader<T> {
    private static final Logger logger = Logger.getLogger(DLNAHeader.class.getName());

    public static DLNAHeader<?> newInstance(Type type, String headerValue) {
        DLNAHeader<?> upnpHeader = null;
        int i = 0;
        while (i < type.getHeaderTypes().length && upnpHeader == null) {
            Class<DLNAHeader<?>> headerClass = type.getHeaderTypes()[i];
            try {
                logger.finest("Trying to parse '" + (Object)((Object)type) + "' with class: " + headerClass.getSimpleName());
                upnpHeader = headerClass.newInstance();
                if (headerValue != null) {
                    upnpHeader.setString(headerValue);
                }
            }
            catch (InvalidHeaderException ex) {
                logger.finest("Invalid header value for tested type: " + headerClass.getSimpleName() + " - " + ex.getMessage());
                upnpHeader = null;
            }
            catch (Exception ex) {
                logger.severe("Error instantiating header of type '" + (Object)((Object)type) + "' with value: " + headerValue);
                logger.log(Level.SEVERE, "Exception root cause: ", Exceptions.unwrap((Throwable)ex));
            }
            ++i;
        }
        return upnpHeader;
    }

    public static enum Type {
        TimeSeekRange("TimeSeekRange.dlna.org", TimeSeekRangeHeader.class),
        XSeekRange("X-Seek-Range", TimeSeekRangeHeader.class),
        PlaySpeed("PlaySpeed.dlna.org", PlaySpeedHeader.class),
        AvailableSeekRange("availableSeekRange.dlna.org", AvailableSeekRangeHeader.class),
        GetAvailableSeekRange("getAvailableSeekRange.dlna.org", GetAvailableSeekRangeHeader.class),
        GetContentFeatures("getcontentFeatures.dlna.org", GetContentFeaturesHeader.class),
        ContentFeatures("contentFeatures.dlna.org", ContentFeaturesHeader.class),
        TransferMode("transferMode.dlna.org", TransferModeHeader.class),
        FriendlyName("friendlyName.dlna.org", FriendlyNameHeader.class),
        PeerManager("peerManager.dlna.org", PeerManagerHeader.class),
        AvailableRange("Available-Range.dlna.org", AvailableRangeHeader.class),
        SCID("scid.dlna.org", SCIDHeader.class),
        RealTimeInfo("realTimeInfo.dlna.org", RealTimeInfoHeader.class),
        ScmsFlag("scmsFlag.dlna.org", ScmsFlagHeader.class),
        WCT("WCT.dlna.org", WCTHeader.class),
        MaxPrate("Max-Prate.dlna.org", MaxPrateHeader.class),
        EventType("Event-Type.dlna.org", EventTypeHeader.class),
        Supported("Supported", SupportedHeader.class),
        BufferInfo("Buffer-Info.dlna.org", BufferInfoHeader.class),
        RTPH264DeInterleaving("rtp-h264-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAACDeInterleaving("rtp-aac-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAMRDeInterleaving("rtp-amr-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAMRWBPlusDeInterleaving("rtp-amrwbplus-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        PRAGMA("PRAGMA", PragmaHeader.class);

        private static Map<String, Type> byName;
        private String httpName;
        private Class<? extends DLNAHeader<?>>[] headerTypes;

        static {
            byName = new HashMap<String, Type>(){
                private static final long serialVersionUID = 2786641076120338594L;
                {
                    Type[] typeArray = Type.values();
                    int n = typeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type t = typeArray[n2];
                        this.put(t.getHttpName(), t);
                        ++n2;
                    }
                }
            };
        }

        @SafeVarargs
        private Type(String httpName, Class<? extends DLNAHeader<?>> ... headerClass) {
            this.httpName = httpName;
            this.headerTypes = headerClass;
        }

        public String getHttpName() {
            return this.httpName;
        }

        public Class<? extends DLNAHeader<?>>[] getHeaderTypes() {
            return this.headerTypes;
        }

        public boolean isValidHeaderType(Class<? extends DLNAHeader<?>> clazz) {
            Class<? extends DLNAHeader<?>>[] classArray = this.getHeaderTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<DLNAHeader<DLNAHeader<?>>> permissibleType = classArray[n2];
                if (permissibleType.isAssignableFrom(clazz)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static Type getByHttpName(String httpName) {
            if (httpName == null) {
                return null;
            }
            return byName.get(httpName);
        }
    }
}

