/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message.header;

import java.util.regex.Pattern;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;
import org.jupnp.support.model.dlna.types.ScmsFlagType;

public class ScmsFlagHeader
extends DLNAHeader<ScmsFlagType> {
    private static final Pattern pattern = Pattern.compile("^[01]{2}$", 2);

    public void setString(String s) {
        if (pattern.matcher(s).matches()) {
            this.setValue(new ScmsFlagType(s.charAt(0) == '0', s.charAt(1) == '0'));
            return;
        }
        throw new InvalidHeaderException("Invalid ScmsFlag header value: " + s);
    }

    public String getString() {
        ScmsFlagType v = (ScmsFlagType)this.getValue();
        return String.valueOf(v.isCopyright() ? "0" : "1") + (v.isOriginal() ? "0" : "1");
    }
}

