/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.binding.xml.UDA10ServiceDescriptorBinderSAXImpl;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Service;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveringUDA10ServiceDescriptorBinderSAXImpl
extends UDA10ServiceDescriptorBinderSAXImpl {
    private final Logger log = LoggerFactory.getLogger(ServiceDescriptorBinder.class);

    @Override
    public <S extends Service> S describe(S undescribedService, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.length() == 0) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            this.log.trace("Reading service from XML descriptor");
            String fixedXml = this.fixBOM(descriptorXml);
            fixedXml = this.fixRetval(fixedXml);
            fixedXml = this.fixQuotes(fixedXml);
            return super.describe(undescribedService, fixedXml);
        }
        catch (DescriptorBindingException e) {
            this.log.warn(e.getMessage());
            return null;
        }
    }

    protected String fixBOM(String descriptorXml) {
        if (descriptorXml.contains("<scpd xmlns=\"urn:Belkin:service-1-0\">")) {
            descriptorXml = descriptorXml.trim().replaceFirst("^([\\W]+)<", "<");
            Matcher junkMatcher = Pattern.compile("^([\\W]+)<").matcher(descriptorXml.trim());
            String newXml = junkMatcher.replaceFirst("<");
            SpecificationViolationReporter.report("Detected UTF-8 BOM, replacing it", new Object[0]);
            return newXml.replaceAll("\u0000", " ");
        }
        return descriptorXml;
    }

    protected String fixRetval(String descriptorXml) {
        if (descriptorXml.contains("<scpd xmlns=\"urn:Belkin:service-1-0\">") && descriptorXml.contains("<retval")) {
            SpecificationViolationReporter.report("Detected invalid service value 'retval', replacing it", null);
            descriptorXml = descriptorXml.replaceAll("<retval/>", " ");
            return descriptorXml.replaceAll("<retval />", " ");
        }
        return descriptorXml;
    }

    protected String fixQuotes(String descriptorXml) {
        if (descriptorXml.contains("<scpd xmlns=\"urn:Belkin:service-1-0\">") && descriptorXml.contains("Key\"")) {
            SpecificationViolationReporter.report("Detected invalid quotes, replacing it", new Object[0]);
            descriptorXml = descriptorXml.replaceAll("\"smartprivateKey\"", "smartprivateKey");
            return descriptorXml.replaceAll("\"pluginprivateKey\"", "pluginprivateKey");
        }
        return descriptorXml;
    }
}

