/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jupnp.model.message.header.AVClientInfoHeader;
import org.jupnp.model.message.header.CallbackHeader;
import org.jupnp.model.message.header.ContentRangeHeader;
import org.jupnp.model.message.header.ContentTypeHeader;
import org.jupnp.model.message.header.DeviceTypeHeader;
import org.jupnp.model.message.header.DeviceUSNHeader;
import org.jupnp.model.message.header.EXTHeader;
import org.jupnp.model.message.header.EventSequenceHeader;
import org.jupnp.model.message.header.HostHeader;
import org.jupnp.model.message.header.InterfaceMacHeader;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.LocationHeader;
import org.jupnp.model.message.header.MANHeader;
import org.jupnp.model.message.header.MXHeader;
import org.jupnp.model.message.header.MaxAgeHeader;
import org.jupnp.model.message.header.NTEventHeader;
import org.jupnp.model.message.header.NTSHeader;
import org.jupnp.model.message.header.PragmaHeader;
import org.jupnp.model.message.header.RangeHeader;
import org.jupnp.model.message.header.RootDeviceHeader;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.model.message.header.ServerHeader;
import org.jupnp.model.message.header.ServiceTypeHeader;
import org.jupnp.model.message.header.ServiceUSNHeader;
import org.jupnp.model.message.header.SoapActionHeader;
import org.jupnp.model.message.header.SubscriptionIdHeader;
import org.jupnp.model.message.header.TimeoutHeader;
import org.jupnp.model.message.header.UDADeviceTypeHeader;
import org.jupnp.model.message.header.UDAServiceTypeHeader;
import org.jupnp.model.message.header.UDNHeader;
import org.jupnp.model.message.header.USNRootDeviceHeader;
import org.jupnp.model.message.header.UserAgentHeader;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpnpHeader<T> {
    private T value;

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public abstract void setString(String var1) throws InvalidHeaderException;

    public abstract String getString();

    public static UpnpHeader newInstance(Type type, String headerValue) {
        Logger log = LoggerFactory.getLogger(UpnpHeader.class);
        UpnpHeader upnpHeader = null;
        int i = 0;
        while (i < type.getHeaderTypes().length && upnpHeader == null) {
            Class<? extends UpnpHeader> headerClass = type.getHeaderTypes()[i];
            try {
                log.trace("Trying to parse '{}' with class: {}", (Object)type, (Object)headerClass.getSimpleName());
                upnpHeader = headerClass.newInstance();
                if (headerValue != null) {
                    upnpHeader.setString(headerValue);
                }
            }
            catch (InvalidHeaderException ex) {
                log.trace("Invalid header value for tested type: {} - {}", (Object)headerClass.getSimpleName(), (Object)ex.getMessage());
                upnpHeader = null;
            }
            catch (Exception ex) {
                log.error("Error instantiating header of type '" + (Object)((Object)type) + "' with value: " + headerValue);
                log.error("Exception root cause: ", Exceptions.unwrap(ex));
            }
            ++i;
        }
        return upnpHeader;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + this.getValue() + "'";
    }

    public static enum Type {
        USN("USN", USNRootDeviceHeader.class, DeviceUSNHeader.class, ServiceUSNHeader.class, UDNHeader.class),
        NT("NT", RootDeviceHeader.class, UDADeviceTypeHeader.class, UDAServiceTypeHeader.class, DeviceTypeHeader.class, ServiceTypeHeader.class, UDNHeader.class, NTEventHeader.class),
        NTS("NTS", NTSHeader.class),
        HOST("HOST", HostHeader.class),
        SERVER("SERVER", ServerHeader.class),
        LOCATION("LOCATION", LocationHeader.class),
        MAX_AGE("CACHE-CONTROL", MaxAgeHeader.class),
        USER_AGENT("USER-AGENT", UserAgentHeader.class),
        CONTENT_TYPE("CONTENT-TYPE", ContentTypeHeader.class),
        MAN("MAN", MANHeader.class),
        MX("MX", MXHeader.class),
        ST("ST", STAllHeader.class, RootDeviceHeader.class, UDADeviceTypeHeader.class, UDAServiceTypeHeader.class, DeviceTypeHeader.class, ServiceTypeHeader.class, UDNHeader.class),
        EXT("EXT", EXTHeader.class),
        SOAPACTION("SOAPACTION", SoapActionHeader.class),
        TIMEOUT("TIMEOUT", TimeoutHeader.class),
        CALLBACK("CALLBACK", CallbackHeader.class),
        SID("SID", SubscriptionIdHeader.class),
        SEQ("SEQ", EventSequenceHeader.class),
        RANGE("RANGE", RangeHeader.class),
        CONTENT_RANGE("CONTENT-RANGE", ContentRangeHeader.class),
        PRAGMA("PRAGMA", PragmaHeader.class),
        EXT_IFACE_MAC("X-CLING-IFACE-MAC", InterfaceMacHeader.class),
        EXT_AV_CLIENT_INFO("X-AV-CLIENT-INFO", AVClientInfoHeader.class);

        private static Map<String, Type> byName;
        private String httpName;
        private Class<? extends UpnpHeader>[] headerTypes;

        static {
            byName = new HashMap<String, Type>(){
                {
                    Type[] typeArray = Type.values();
                    int n = typeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type t = typeArray[n2];
                        this.put(t.getHttpName(), t);
                        ++n2;
                    }
                }
            };
        }

        private Type(String httpName, Class<? extends UpnpHeader> ... headerClass) {
            this.httpName = httpName;
            this.headerTypes = headerClass;
        }

        public String getHttpName() {
            return this.httpName;
        }

        public Class<? extends UpnpHeader>[] getHeaderTypes() {
            return this.headerTypes;
        }

        public boolean isValidHeaderType(Class<? extends UpnpHeader> clazz) {
            Class<? extends UpnpHeader>[] classArray = this.getHeaderTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends UpnpHeader> permissibleType = classArray[n2];
                if (permissibleType.isAssignableFrom(clazz)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static Type getByHttpName(String httpName) {
            if (httpName == null) {
                return null;
            }
            return byName.get(httpName.toUpperCase(Locale.ENGLISH));
        }
    }
}

