/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeResponseMessage;
import org.jupnp.model.message.gena.OutgoingSubscribeRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingSubscribe
extends SendingSync<OutgoingSubscribeRequestMessage, IncomingSubscribeResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(SendingSubscribe.class);
    protected final RemoteGENASubscription subscription;

    public SendingSubscribe(UpnpService upnpService, RemoteGENASubscription subscription, List<NetworkAddress> activeStreamServers) {
        super(upnpService, new OutgoingSubscribeRequestMessage(subscription, subscription.getEventCallbackURLs(activeStreamServers, upnpService.getConfiguration().getNamespace()), upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        if (!((OutgoingSubscribeRequestMessage)this.getInputMessage()).hasCallbackURLs()) {
            this.log.trace("Subscription failed, no active local callback URLs available (network disabled?)");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SendingSubscribe.this.subscription.fail(null);
                }
            });
            return null;
        }
        this.log.trace("Sending subscription request: " + this.getInputMessage());
        try {
            this.getUpnpService().getRegistry().registerPendingRemoteSubscription(this.subscription);
            StreamResponseMessage response = null;
            try {
                response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            }
            catch (RouterException ex) {
                this.onSubscriptionFailure();
                this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
                return null;
            }
            if (response == null) {
                this.onSubscriptionFailure();
                return null;
            }
            final IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
            if (((UpnpResponse)response.getOperation()).isFailed()) {
                this.log.trace("Subscription failed, response was: " + responseMessage);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SendingSubscribe.this.subscription.fail((UpnpResponse)responseMessage.getOperation());
                    }
                });
            } else if (!responseMessage.isValidHeaders()) {
                this.log.error("Subscription failed, invalid or missing (SID, Timeout) response headers");
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SendingSubscribe.this.subscription.fail((UpnpResponse)responseMessage.getOperation());
                    }
                });
            } else {
                this.log.trace("Subscription established, adding to registry, response was: " + response);
                this.subscription.setSubscriptionId(responseMessage.getSubscriptionId());
                this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
                this.getUpnpService().getRegistry().addRemoteSubscription(this.subscription);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SendingSubscribe.this.subscription.establish();
                    }
                });
            }
            IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = responseMessage;
            return incomingSubscribeResponseMessage;
        }
        finally {
            this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
        }
    }

    protected void onSubscriptionFailure() {
        this.log.trace("Subscription failed");
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SendingSubscribe.this.subscription.fail(null);
            }
        });
    }
}

