/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.OutgoingUnsubscribeRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingUnsubscribe
extends SendingSync<OutgoingUnsubscribeRequestMessage, StreamResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(SendingUnsubscribe.class);
    protected final RemoteGENASubscription subscription;

    public SendingUnsubscribe(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingUnsubscribeRequestMessage(subscription, upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        this.log.trace("Sending unsubscribe request: " + this.getInputMessage());
        StreamResponseMessage response = null;
        try {
            StreamResponseMessage streamResponseMessage = response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            this.onUnsubscribe(response);
            return streamResponseMessage;
        }
        catch (Throwable throwable) {
            this.onUnsubscribe(response);
            throw throwable;
        }
    }

    protected void onUnsubscribe(final StreamResponseMessage response) {
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (response == null) {
                    SendingUnsubscribe.this.log.trace("Unsubscribe failed, no response received");
                    SendingUnsubscribe.this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, null);
                } else if (((UpnpResponse)response.getOperation()).isFailed()) {
                    SendingUnsubscribe.this.log.trace("Unsubscribe failed, response was: " + response);
                    SendingUnsubscribe.this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, (UpnpResponse)response.getOperation());
                } else {
                    SendingUnsubscribe.this.log.trace("Unsubscribe successful, response was: " + response);
                    SendingUnsubscribe.this.subscription.end(null, (UpnpResponse)response.getOperation());
                }
            }
        });
    }
}

