/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.Service;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.registry.LocalItems;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryListener;
import org.jupnp.registry.RegistryMaintainer;
import org.jupnp.registry.RemoteItems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryImpl
implements Registry {
    private Logger log = LoggerFactory.getLogger(Registry.class);
    protected UpnpService upnpService;
    protected RegistryMaintainer registryMaintainer;
    protected final Set<RemoteGENASubscription> pendingSubscriptionsLock = new HashSet<RemoteGENASubscription>();
    protected Object lock = new Object();
    protected final Set<RegistryListener> registryListeners = new CopyOnWriteArraySet<RegistryListener>();
    protected final Set<RegistryItem<URI, Resource>> resourceItems = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final List<Runnable> pendingExecutions = new LinkedList<Runnable>();
    protected final ReentrantReadWriteLock remoteItemsLock = new ReentrantReadWriteLock(true);
    protected final ReentrantReadWriteLock localItemsLock = new ReentrantReadWriteLock(true);
    protected final RemoteItems remoteItems = new RemoteItems(this);
    protected final LocalItems localItems = new LocalItems(this);

    public RegistryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryImpl(UpnpService upnpService) {
        this.log.trace("Creating Registry: " + this.getClass().getName());
        this.upnpService = upnpService;
        this.log.trace("Starting registry background maintenance...");
        Object object = this.lock;
        synchronized (object) {
            this.registryMaintainer = this.createRegistryMaintainer();
            if (this.registryMaintainer != null) {
                this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
            }
        }
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.getUpnpService().getConfiguration();
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.getUpnpService().getProtocolFactory();
    }

    protected RegistryMaintainer createRegistryMaintainer() {
        return new RegistryMaintainer(this, this.getConfiguration().getRegistryMaintenanceIntervalMillis());
    }

    @Override
    public void addListener(RegistryListener listener) {
        this.registryListeners.add(listener);
    }

    @Override
    public void removeListener(RegistryListener listener) {
        this.registryListeners.remove(listener);
    }

    @Override
    public Collection<RegistryListener> getListeners() {
        return Collections.unmodifiableCollection(this.registryListeners);
    }

    @Override
    public boolean notifyDiscoveryStart(final RemoteDevice device) {
        if (this.getRemoteDevice(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), true) != null) {
            this.log.trace("Not notifying listeners, already registered: " + device);
            return false;
        }
        for (final RegistryListener listener : this.getListeners()) {
            this.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.remoteDeviceDiscoveryStarted(RegistryImpl.this, device);
                }
            });
        }
        return true;
    }

    @Override
    public void notifyDiscoveryFailure(final RemoteDevice device, final Exception ex) {
        for (final RegistryListener listener : this.getListeners()) {
            this.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.remoteDeviceDiscoveryFailed(RegistryImpl.this, device, ex);
                }
            });
        }
    }

    @Override
    public void addDevice(LocalDevice localDevice) {
        this.remoteItemsLock.readLock().lock();
        try {
            this.localItemsLock.writeLock().lock();
            try {
                this.localItems.add(localDevice);
            }
            finally {
                this.localItemsLock.writeLock().unlock();
            }
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    @Override
    public void addDevice(LocalDevice localDevice, DiscoveryOptions options) {
        this.remoteItemsLock.readLock().lock();
        try {
            this.localItemsLock.writeLock().lock();
            try {
                this.localItems.add(localDevice, options);
            }
            finally {
                this.localItemsLock.writeLock().unlock();
            }
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    @Override
    public void setDiscoveryOptions(UDN udn, DiscoveryOptions options) {
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.setDiscoveryOptions(udn, options);
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public DiscoveryOptions getDiscoveryOptions(UDN udn) {
        this.localItemsLock.readLock().lock();
        try {
            DiscoveryOptions discoveryOptions = this.localItems.getDiscoveryOptions(udn);
            return discoveryOptions;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    @Override
    public void addDevice(RemoteDevice remoteDevice) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.localItemsLock.readLock().lock();
            try {
                this.remoteItems.add(remoteDevice);
            }
            finally {
                this.localItemsLock.readLock().unlock();
            }
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean update(RemoteDeviceIdentity rdIdentity) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.localItemsLock.readLock().lock();
            try {
                boolean bl = this.remoteItems.update(rdIdentity);
                this.localItemsLock.readLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.localItemsLock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeDevice(LocalDevice localDevice) {
        this.localItemsLock.writeLock().lock();
        try {
            boolean bl = this.localItems.remove(localDevice);
            return bl;
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeDevice(RemoteDevice remoteDevice) {
        this.remoteItemsLock.writeLock().lock();
        try {
            boolean bl = this.remoteItems.remove(remoteDevice);
            return bl;
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void removeAllLocalDevices() {
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.removeAll();
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void removeAllRemoteDevices() {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.removeAll();
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeDevice(UDN udn) {
        Device device = this.getDevice(udn, true);
        if (device != null && device instanceof LocalDevice) {
            return this.removeDevice((LocalDevice)device);
        }
        if (device != null && device instanceof RemoteDevice) {
            return this.removeDevice((RemoteDevice)device);
        }
        return false;
    }

    @Override
    public Device getDevice(UDN udn, boolean rootOnly) {
        Device device = this.getLocalDevice(udn, rootOnly);
        if (device != null) {
            return device;
        }
        device = this.getRemoteDevice(udn, rootOnly);
        if (device != null) {
            return device;
        }
        return null;
    }

    @Override
    public LocalDevice getLocalDevice(UDN udn, boolean rootOnly) {
        this.localItemsLock.readLock().lock();
        try {
            LocalDevice localDevice = (LocalDevice)this.localItems.get(udn, rootOnly);
            return localDevice;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    @Override
    public RemoteDevice getRemoteDevice(UDN udn, boolean rootOnly) {
        this.remoteItemsLock.readLock().lock();
        try {
            RemoteDevice remoteDevice = (RemoteDevice)this.remoteItems.get(udn, rootOnly);
            return remoteDevice;
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    @Override
    public Collection<LocalDevice> getLocalDevices() {
        this.localItemsLock.readLock().lock();
        try {
            Collection<LocalDevice> collection = Collections.unmodifiableCollection(this.localItems.get());
            return collection;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    @Override
    public Collection<RemoteDevice> getRemoteDevices() {
        this.remoteItemsLock.readLock().lock();
        try {
            Collection<RemoteDevice> collection = Collections.unmodifiableCollection(this.remoteItems.get());
            return collection;
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    @Override
    public Collection<Device> getDevices() {
        HashSet<Object> all = new HashSet<Object>();
        this.remoteItemsLock.readLock().lock();
        try {
            all.addAll(this.remoteItems.get());
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
        this.localItemsLock.readLock().lock();
        try {
            all.addAll(this.localItems.get());
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
        return Collections.unmodifiableCollection(all);
    }

    @Override
    public Collection<Device> getDevices(DeviceType deviceType) {
        HashSet devices = new HashSet();
        this.remoteItemsLock.readLock().lock();
        try {
            devices.addAll(this.remoteItems.get(deviceType));
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
        this.localItemsLock.readLock().lock();
        try {
            devices.addAll(this.localItems.get(deviceType));
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
        return Collections.unmodifiableCollection(devices);
    }

    @Override
    public Collection<Device> getDevices(ServiceType serviceType) {
        HashSet devices = new HashSet();
        this.remoteItemsLock.readLock().lock();
        try {
            devices.addAll(this.remoteItems.get(serviceType));
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
        this.localItemsLock.readLock().lock();
        try {
            devices.addAll(this.localItems.get(serviceType));
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
        return Collections.unmodifiableCollection(devices);
    }

    @Override
    public Service getService(ServiceReference serviceReference) {
        Device device = this.getDevice(serviceReference.getUdn(), false);
        if (device != null) {
            return device.findService(serviceReference.getServiceId());
        }
        return null;
    }

    @Override
    public Resource getResource(URI pathQuery) throws IllegalArgumentException {
        if (pathQuery.isAbsolute()) {
            throw new IllegalArgumentException("Resource URI can not be absolute, only path and query:" + pathQuery);
        }
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            Resource resource = resourceItem.getItem();
            if (!resource.matches(pathQuery)) continue;
            return resource;
        }
        if (pathQuery.getPath().endsWith("/")) {
            URI pathQueryWithoutSlash = URI.create(pathQuery.toString().substring(0, pathQuery.toString().length() - 1));
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                Resource resource = resourceItem.getItem();
                if (!resource.matches(pathQueryWithoutSlash)) continue;
                return resource;
            }
        }
        return null;
    }

    @Override
    public <T extends Resource> T getResource(Class<T> resourceType, URI pathQuery) throws IllegalArgumentException {
        Resource resource = this.getResource(pathQuery);
        if (resource != null && resourceType.isAssignableFrom(resource.getClass())) {
            return (T)resource;
        }
        return null;
    }

    @Override
    public Collection<Resource> getResources() {
        HashSet<Resource> s = new HashSet<Resource>(this.resourceItems.size());
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            s.add(resourceItem.getItem());
        }
        return s;
    }

    @Override
    public <T extends Resource> Collection<T> getResources(Class<T> resourceType) {
        HashSet<Resource> s = new HashSet<Resource>(this.resourceItems.size());
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            if (!resourceType.isAssignableFrom(resourceItem.getItem().getClass())) continue;
            s.add(resourceItem.getItem());
        }
        return s;
    }

    @Override
    public void addResource(Resource resource) {
        this.addResource(resource, 0);
    }

    @Override
    public void addResource(Resource resource, int maxAgeSeconds) {
        RegistryItem<URI, Resource> resourceItem = new RegistryItem<URI, Resource>(resource.getPathQuery(), resource, maxAgeSeconds);
        this.resourceItems.remove(resourceItem);
        this.resourceItems.add(resourceItem);
    }

    @Override
    public boolean removeResource(Resource resource) {
        return this.resourceItems.remove(new RegistryItem(resource.getPathQuery()));
    }

    @Override
    public void addLocalSubscription(LocalGENASubscription subscription) {
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.addSubscription(subscription);
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public LocalGENASubscription getLocalSubscription(String subscriptionId) {
        this.localItemsLock.readLock().lock();
        try {
            LocalGENASubscription localGENASubscription = (LocalGENASubscription)this.localItems.getSubscription(subscriptionId);
            return localGENASubscription;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    @Override
    public boolean updateLocalSubscription(LocalGENASubscription subscription) {
        this.localItemsLock.writeLock().lock();
        try {
            boolean bl = this.localItems.updateSubscription(subscription);
            return bl;
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeLocalSubscription(LocalGENASubscription subscription) {
        this.localItemsLock.writeLock().lock();
        try {
            boolean bl = this.localItems.removeSubscription(subscription);
            return bl;
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void addRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.addSubscription(subscription);
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public RemoteGENASubscription getRemoteSubscription(String subscriptionId) {
        this.remoteItemsLock.readLock().lock();
        try {
            RemoteGENASubscription remoteGENASubscription = (RemoteGENASubscription)this.remoteItems.getSubscription(subscriptionId);
            return remoteGENASubscription;
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    @Override
    public void updateRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.updateSubscription(subscription);
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void removeRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.removeSubscription(subscription);
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void advertiseLocalDevices() {
        this.localItemsLock.readLock().lock();
        try {
            this.localItems.advertiseLocalDevices();
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.log.trace("Shutting down registry...");
        Object list = this.lock;
        synchronized (list) {
            if (this.registryMaintainer != null) {
                this.registryMaintainer.stop();
            }
        }
        List<Runnable> list2 = this.pendingExecutions;
        synchronized (list2) {
            this.log.trace("Executing final pending operations on shutdown: {}", (Object)this.pendingExecutions.size());
            this.runPendingExecutions(false);
        }
        for (RegistryListener registryListener : this.registryListeners) {
            registryListener.beforeShutdown(this);
        }
        for (RegistryItem registryItem : this.resourceItems) {
            ((Resource)registryItem.getItem()).shutdown();
        }
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.shutdown();
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.shutdown();
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
        for (RegistryListener registryListener : this.registryListeners) {
            registryListener.afterShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registryMaintainer != null) {
                this.log.trace("Pausing registry maintenance");
                this.runPendingExecutions(true);
                this.registryMaintainer.stop();
                this.registryMaintainer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registryMaintainer == null) {
                this.log.trace("Resuming registry maintenance");
                this.remoteItemsLock.writeLock().lock();
                try {
                    this.localItemsLock.readLock().lock();
                    try {
                        this.remoteItems.resume();
                    }
                    finally {
                        this.localItemsLock.readLock().unlock();
                    }
                }
                finally {
                    this.remoteItemsLock.writeLock().unlock();
                }
                this.registryMaintainer = this.createRegistryMaintainer();
                if (this.registryMaintainer != null) {
                    this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaused() {
        Object object = this.lock;
        synchronized (object) {
            return this.registryMaintainer == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maintain() {
        this.log.trace("Maintaining registry...");
        Iterator<RegistryItem<URI, Resource>> it = this.resourceItems.iterator();
        while (it.hasNext()) {
            RegistryItem<URI, Resource> item = it.next();
            if (!item.getExpirationDetails().hasExpired()) continue;
            this.log.trace("Removing expired resource: " + item);
            it.remove();
        }
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                resourceItem.getItem().maintain(this.pendingExecutions, resourceItem.getExpirationDetails());
            }
        }
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.maintain();
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.maintain();
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
        this.runPendingExecutions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeAsyncProtocol(Runnable runnable) {
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            this.pendingExecutions.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runPendingExecutions(boolean async) {
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            this.log.trace("Executing pending operations: {}", (Object)this.pendingExecutions.size());
            for (Runnable pendingExecution : this.pendingExecutions) {
                if (async) {
                    this.getConfiguration().getAsyncProtocolExecutor().execute(pendingExecution);
                    continue;
                }
                pendingExecution.run();
            }
            if (this.pendingExecutions.size() > 0) {
                this.pendingExecutions.clear();
            }
        }
    }

    public void printDebugLog() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("====================================    REMOTE   ================================================");
            this.remoteItemsLock.readLock().lock();
            try {
                for (RemoteDevice remoteDevice : this.remoteItems.get()) {
                    this.log.trace(remoteDevice.toString());
                }
            }
            finally {
                this.remoteItemsLock.readLock().unlock();
            }
            this.log.trace("====================================    LOCAL    ================================================");
            this.localItemsLock.readLock().lock();
            try {
                for (LocalDevice localDevice : this.localItems.get()) {
                    this.log.trace(localDevice.toString());
                }
            }
            finally {
                this.localItemsLock.readLock().unlock();
            }
            this.log.trace("====================================  RESOURCES  ================================================");
            for (RegistryItem registryItem : this.resourceItems) {
                this.log.trace(registryItem.toString());
            }
            this.log.trace("=================================================================================================");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPendingRemoteSubscription(RemoteGENASubscription subscription) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            this.pendingSubscriptionsLock.add(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPendingRemoteSubscription(RemoteGENASubscription subscription) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            if (this.pendingSubscriptionsLock.remove(subscription)) {
                this.pendingSubscriptionsLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteGENASubscription getWaitRemoteSubscription(String subscriptionId) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            do {
                RemoteGENASubscription subscription;
                if ((subscription = this.getRemoteSubscription(subscriptionId)) != null) {
                    return subscription;
                }
                if (this.pendingSubscriptionsLock.isEmpty()) continue;
                try {
                    this.log.trace("Subscription not found, waiting for pending subscription procedure to terminate.");
                    this.pendingSubscriptionsLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.pendingSubscriptionsLock.isEmpty());
        }
        return null;
    }
}

