/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.spi.UpnpStream;
import org.jupnp.util.Exceptions;
import org.jupnp.util.io.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpExchangeUpnpStream
extends UpnpStream {
    private final Logger log = LoggerFactory.getLogger((String)HttpExchangeUpnpStream.class.getName());
    private HttpExchange httpExchange;

    public HttpExchangeUpnpStream(ProtocolFactory protocolFactory, HttpExchange httpExchange) {
        super(protocolFactory);
        this.httpExchange = httpExchange;
    }

    public HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    @Override
    public void run() {
        try {
            byte[] bodyBytes;
            this.log.trace("Processing HTTP request: {} {}", (Object)this.getHttpExchange().getRequestMethod(), (Object)this.getHttpExchange().getRequestURI());
            StreamRequestMessage requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(this.getHttpExchange().getRequestMethod()), this.getHttpExchange().getRequestURI());
            if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
                this.log.trace("Method not supported by UPnP stack: {}", (Object)this.getHttpExchange().getRequestMethod());
                throw new RuntimeException("Method not supported: " + this.getHttpExchange().getRequestMethod());
            }
            ((UpnpRequest)requestMessage.getOperation()).setHttpMinorVersion(this.getHttpExchange().getProtocol().toUpperCase(Locale.ROOT).equals("HTTP/1.1") ? 1 : 0);
            this.log.trace("Created new request message: {}", (Object)requestMessage);
            requestMessage.setConnection(this.createConnection());
            requestMessage.setHeaders(new UpnpHeaders(this.getHttpExchange().getRequestHeaders()));
            try (InputStream is = null;){
                is = this.getHttpExchange().getRequestBody();
                bodyBytes = IO.readBytes(is);
            }
            this.log.trace("Reading request body bytes: {}", (Object)bodyBytes.length);
            if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
                this.log.trace("Request contains textual entity body, converting then setting string on message");
                requestMessage.setBodyCharacters(bodyBytes);
            } else if (bodyBytes.length > 0) {
                this.log.trace("Request contains binary entity body, setting bytes on message");
                requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
            } else {
                this.log.trace("Request did not contain entity body");
            }
            StreamResponseMessage responseMessage = this.process(requestMessage);
            if (responseMessage != null) {
                this.log.trace("Preparing HTTP response message: {}", (Object)responseMessage);
                this.getHttpExchange().getResponseHeaders().putAll(responseMessage.getHeaders());
                byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
                int contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
                this.log.trace("Sending HTTP response message: {} with content length: {}", (Object)responseMessage, (Object)contentLength);
                this.getHttpExchange().sendResponseHeaders(((UpnpResponse)responseMessage.getOperation()).getStatusCode(), contentLength);
                if (contentLength > 0) {
                    this.log.trace("Response message has body, writing bytes to stream...");
                    try (OutputStream os = null;){
                        os = this.getHttpExchange().getResponseBody();
                        IO.writeBytes(os, responseBodyBytes);
                        os.flush();
                    }
                }
            } else {
                this.log.trace("Sending HTTP response status: {}", (Object)404);
                this.getHttpExchange().sendResponseHeaders(404, -1L);
            }
            this.responseSent(responseMessage);
        }
        catch (Throwable t) {
            this.log.trace("Exception occured during UPnP stream processing: {}", t);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Cause: {}", (Object)Exceptions.unwrap(t), (Object)Exceptions.unwrap(t));
            }
            try {
                this.httpExchange.sendResponseHeaders(500, -1L);
            }
            catch (IOException ex) {
                this.log.warn("Couldn't send error response: {}", (Object)ex.getMessage(), (Object)ex);
            }
            this.responseException(t);
        }
    }

    protected abstract Connection createConnection();
}

