/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;

public class Iterators {

    public static class Empty<E>
    implements Iterator<E> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Singular<E>
    implements Iterator<E> {
        protected final E element;
        protected int current;

        public Singular(E element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.current == 0;
        }

        @Override
        public E next() {
            ++this.current;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Synchronized<E>
    implements Iterator<E> {
        final Iterator<E> wrapped;
        int nextIndex = 0;
        boolean removedCurrent = false;

        public Synchronized(Collection<E> collection) {
            this.wrapped = new CopyOnWriteArrayList<E>(collection).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            this.removedCurrent = false;
            ++this.nextIndex;
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            if (this.nextIndex == 0) {
                throw new IllegalStateException("Call next() first");
            }
            if (this.removedCurrent) {
                throw new IllegalStateException("Already removed current, call next()");
            }
            this.synchronizedRemove(this.nextIndex - 1);
            this.removedCurrent = true;
        }

        protected abstract void synchronizedRemove(int var1);
    }
}

