/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.util.Dictionary;
import java.util.Map;
import org.jupnp.util.SpecificationViolationReporter;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationViolationReporterConfig
implements ManagedService {
    private static final String SPECIFICATION_VIOLATION_REPORTER_ENABLED = "specificationViolationReporterEnabled";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean specificationViolationReportingEnabled = true;

    public void activate(ComponentContext ctx) {
        this.configure(ctx.getProperties());
        this.configureReporter();
    }

    public void modified(Map<String, Object> config) {
        this.configureReporter();
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.configure(properties);
    }

    private void configure(Dictionary config) {
        Object enabledObj = config.get(SPECIFICATION_VIOLATION_REPORTER_ENABLED);
        if (enabledObj != null && enabledObj instanceof Boolean) {
            this.specificationViolationReportingEnabled = (Boolean)enabledObj;
        }
    }

    private void configureReporter() {
        if (this.specificationViolationReportingEnabled) {
            this.logger.info("Enabling jUPnP specification violation reporter");
            SpecificationViolationReporter.enableReporting();
        } else {
            this.logger.info("Disabling jUPnP specification violation reporter");
            SpecificationViolationReporter.disableReporting();
        }
    }
}

