/*
 * Decompiled with CFR 0.152.
 */
package juzu.arquillian;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class Helper {
    public static WebArchive createBaseServletDeployment() {
        return Helper.createBaseServletDeployment("weld");
    }

    public static WebArchive createBaseServletDeployment(String injectorVendor) {
        return Helper.createBaseDeployment("servlet/web.xml", injectorVendor);
    }

    public static WebArchive createBasePortletDeployment() {
        return Helper.createBaseDeployment("portlet/web.xml", "weld");
    }

    private static WebArchive createBaseDeployment(String webXMLPath, String injectorProvider) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        byte[] buffer = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = Helper.class.getResourceAsStream(webXMLPath);
        if (in == null) {
            throw new AssertionError((Object)("Could not locate " + webXMLPath + " web.xml for juzu testing"));
        }
        try {
            int l = in.read(buffer);
            while (l != -1) {
                baos.write(buffer, 0, l);
                l = in.read(buffer);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Could not find read " + webXMLPath + " web.xml for juzu testing"));
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable ignore) {}
        }
        String webXML = baos.toString();
        webXML = String.format(webXML, injectorProvider);
        war.setWebXML((Asset)new StringAsset(webXML));
        return war;
    }
}

