/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking.models;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import juzu.Format;
import juzu.Mapped;
import org.sample.booking.models.Hotel;
import org.sample.booking.models.User;

@Mapped
public class Booking {
    public String id;
    public User user;
    public Hotel hotel;
    @NotNull
    @Format(value="yyyy-MM-dd")
    public Date checkinDate;
    @NotNull
    @Format(value="yyyy-MM-dd")
    public Date checkoutDate;
    @NotNull(message="Credit card number is required")
    @Pattern(regexp="^\\d{16}$", message="Credit card number must be numeric and 16 digits long")
    public String creditCard = "";
    @Size(min=3, max=70, message="Credit card name must be between 3 and 70 letters long")
    @NotNull(message="Credit card name is required")
    public String creditCardName;
    public int creditCardExpiryMonth;
    public int creditCardExpiryYear;
    public boolean smoking;
    public int beds;
    private static final AtomicInteger sequence = new AtomicInteger();
    private static final Map<String, Booking> bookings = new LinkedHashMap();

    public Booking() {
    }

    public Booking(Hotel hotel, User user) {
        this.hotel = hotel;
        this.user = user;
    }

    public BigDecimal getTotal() {
        return this.hotel.price.multiply(new BigDecimal(this.getNights()));
    }

    public int getNights() {
        return 2;
    }

    public String getDescription() {
        DateFormat df = DateFormat.getDateInstance(2);
        return this.hotel == null ? null : this.hotel.name + ", " + df.format(this.checkinDate) + " to " + df.format(this.checkoutDate);
    }

    public String toString() {
        return "Booking(" + this.user + "," + this.hotel + ")";
    }

    public void create() {
        this.id = "" + sequence;
        bookings.put(this.id, this);
    }

    public void delete() {
        bookings.remove(this.id);
        this.id = null;
    }

    public static Booking find(String id) {
        return (Booking)bookings.get(id);
    }

    public static List<Booking> findByUser(String username) {
        ArrayList<Booking> list2 = new ArrayList<Booking>();
        for (Booking booking : bookings.values()) {
            if (!booking.user.username.equals(username)) continue;
            list2.add(booking);
        }
        return list2;
    }
}

