/*
 * Decompiled with CFR 0.152.
 */
package org.juzu;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.juzu.text.Printer;

public class Response {
    public static Action.Redirect redirect(String location) {
        return new Action.Redirect(location);
    }

    public static Mime ok(final String content) {
        return new Mime(){

            public void send(Printer printer) throws IOException {
                printer.write(content);
            }
        };
    }

    public static Render ok(final String title, final String content) {
        return new Render(){

            public String getTitle() {
                return title;
            }

            public void send(Printer printer) throws IOException {
                printer.write(content);
            }
        };
    }

    public static Resource notFound() {
        return Response.notFound(null);
    }

    public static Resource notFound(String content) {
        return Response.status(404, content);
    }

    public static Resource status(int code) {
        return Response.status(code, null);
    }

    public static Resource status(final int code, final String content) {
        return new Resource(){

            public int getStatus() {
                return code;
            }

            public void send(Printer printer) throws IOException {
                if (content != null) {
                    printer.write(content);
                }
            }
        };
    }

    public static abstract class Resource
    extends Mime {
        public abstract int getStatus();
    }

    public static abstract class Render
    extends Mime {
        public abstract String getTitle();
    }

    public static abstract class Mime
    extends Response
    implements Stream {
    }

    public static class Action
    extends Response {

        public static class Redirect
        extends Action {
            private final String location;

            public Redirect(String location) {
                this.location = location;
            }

            public String getLocation() {
                return this.location;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Redirect) {
                    Redirect that = (Redirect)obj;
                    return this.location.equals(that.location);
                }
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Render
        extends Action
        implements Update {
            final String methodId;
            final Map<String, String> parameters;

            public Render(String methodId) {
                this.methodId = methodId;
                this.parameters = new HashMap<String, String>();
            }

            @Override
            public Render setParameter(String parameterName, String parameterValue) {
                if (parameterName == null) {
                    throw new NullPointerException();
                }
                if (parameterValue == null) {
                    throw new NullPointerException();
                }
                this.parameters.put(parameterName, parameterValue);
                return this;
            }

            @Override
            public Map<String, String> getParameters() {
                return this.parameters;
            }

            @Override
            public String getMethodId() {
                return this.methodId;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Render) {
                    Render that = (Render)obj;
                    return this.methodId.equals(that.methodId) && ((Object)this.parameters).equals(that.parameters);
                }
                return false;
            }

            public String toString() {
                return "Response.Action.Render[methodId=" + this.methodId + ",parameters" + this.parameters + "]";
            }
        }
    }

    public static interface Stream {
        public void send(Printer var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Update {
        public String getMethodId();

        public Update setParameter(String var1, String var2);

        public Map<String, String> getParameters();
    }
}

