/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationError;
import org.juzu.impl.compiler.VirtualFileManager;
import org.juzu.impl.compiler.file.FileKey;
import org.juzu.impl.compiler.file.JavaFileObjectImpl;
import org.juzu.impl.compiler.file.SimpleFileManager;
import org.juzu.impl.fs.Visitor;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.spi.fs.SimpleFileSystem;
import org.juzu.impl.spi.fs.disk.DiskFileSystem;
import org.juzu.impl.spi.fs.jar.JarFileSystem;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.Spliterator;
import org.juzu.text.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    static final Pattern PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\(([^\\)]*)\\)");
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private VirtualFileManager fileManager;
    private Set<Processor> processors;

    public static Builder builder() {
        return new Builder(null, null, null, new ArrayList());
    }

    public Compiler(ReadFileSystem<?> sourcePath, ReadWriteFileSystem<?> output) {
        this(sourcePath, output, output);
    }

    public Compiler(ReadFileSystem<?> sourcePath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput) {
        this(sourcePath, Collections.emptyList(), sourceOutput, classOutput);
    }

    public Compiler(ReadFileSystem<?> sourcePath, SimpleFileSystem<?> classPath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput) {
        this(sourcePath, Collections.singletonList(classPath), sourceOutput, classOutput);
    }

    public Compiler(ReadFileSystem<?> sourcePath, Collection<SimpleFileSystem<?>> classPath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput) {
        this.fileManager = new VirtualFileManager(this.compiler.getStandardFileManager(null, null, null), sourcePath, classPath, sourceOutput, classOutput);
        this.processors = new HashSet<Processor>();
    }

    public void addAnnotationProcessor(Processor annotationProcessorType) {
        if (annotationProcessorType == null) {
            throw new NullPointerException("No null processor allowed");
        }
        this.processors.add(annotationProcessorType);
    }

    public ReadWriteFileSystem<Object> getSourceOutput() {
        return (ReadWriteFileSystem)this.fileManager.sourceOutput.getFileSystem();
    }

    public ReadWriteFileSystem<Object> getClassOutput() {
        return (ReadWriteFileSystem)this.fileManager.classOutput.getFileSystem();
    }

    public List<CompilationError> compile(String ... compilationUnits) throws IOException {
        return this.compile(this.getFromSourcePath(this.fileManager.sourcePath, compilationUnits));
    }

    public List<CompilationError> compile() throws IOException {
        return this.compile(this.getFromSourcePath(this.fileManager.sourcePath));
    }

    private <P> Iterable<JavaFileObject> getFromSourcePath(SimpleFileManager<P> manager, String ... compilationUnits) throws IOException {
        ArrayList tmp = new ArrayList();
        ArrayList<JavaFileObject> javaFiles = new ArrayList<JavaFileObject>();
        for (String compilationUnit : compilationUnits) {
            ArrayList<String> names = Spliterator.split(compilationUnit, '/', tmp);
            String name = (String)tmp.get(tmp.size() - 1);
            if (!name.endsWith(".java")) {
                throw new IllegalArgumentException("Illegal compilation unit: " + compilationUnit);
            }
            P file = manager.getFileSystem().getPath(names);
            if (file == null) {
                throw new IllegalArgumentException("Could not find compilation unit: " + compilationUnit);
            }
            StringBuilder sb = new StringBuilder();
            manager.getFileSystem().packageOf(file, '.', sb);
            FileKey key = FileKey.newJavaName(sb.toString(), name.substring(0, name.length()));
            javaFiles.add(manager.getReadable(key));
        }
        return javaFiles;
    }

    private <P> Iterable<JavaFileObject> getFromSourcePath(final SimpleFileManager<P> fileManager) throws IOException {
        final ArrayList<JavaFileObject> javaFiles = new ArrayList<JavaFileObject>();
        ((ReadFileSystem)fileManager.getFileSystem()).traverse(new Visitor.Default<P>(){

            @Override
            public void file(P file, String name) throws IOException {
                if (name.endsWith(".java")) {
                    StringBuilder sb = new StringBuilder();
                    fileManager.getFileSystem().packageOf(file, '.', sb);
                    FileKey key = FileKey.newJavaName(sb.toString(), name);
                    javaFiles.add(fileManager.getReadable(key));
                }
            }
        });
        return javaFiles;
    }

    private List<CompilationError> compile(Iterable<JavaFileObject> compilationUnits) throws IOException {
        final ArrayList errors = new ArrayList();
        DiagnosticListener<JavaFileObject> listener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    int columnNumber = (int)diagnostic.getColumnNumber();
                    int lineNumber = (int)diagnostic.getLineNumber();
                    Location location = columnNumber > 0 && lineNumber > 0 ? new Location(columnNumber, lineNumber) : null;
                    String message = diagnostic.getMessage(null);
                    ErrorCode code = null;
                    List<String> arguments = Collections.emptyList();
                    Matcher matcher = PATTERN.matcher(message);
                    if (matcher.find()) {
                        BaseProcessor baseProcessor;
                        Processor processor;
                        String codeKey = matcher.group(1);
                        Iterator<Object> i$ = Compiler.this.processors.iterator();
                        while (i$.hasNext() && (!((processor = (Processor)i$.next()) instanceof BaseProcessor) || (code = (baseProcessor = (BaseProcessor)processor).decode(codeKey)) == null)) {
                        }
                        if (matcher.group(2).length() > 0) {
                            arguments = new ArrayList();
                            for (String argument : Spliterator.split(matcher.group(2), ',')) {
                                arguments.add(argument.trim());
                            }
                        }
                    }
                    JavaFileObject obj = diagnostic.getSource();
                    String source = null;
                    File resolvedFile = null;
                    if (obj != null) {
                        source = obj.toUri().getPath();
                        if (obj instanceof JavaFileObjectImpl) {
                            JavaFileObjectImpl foo = (JavaFileObjectImpl)obj;
                            try {
                                resolvedFile = foo.getFile();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                    }
                    errors.add(new CompilationError(code, arguments, source, resolvedFile, location, message));
                }
            }
        };
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, (DiagnosticListener<? super JavaFileObject>)listener, Collections.<String>emptyList(), null, compilationUnits);
        task.setProcessors(this.processors);
        boolean ok = task.call();
        this.fileManager.sourceOutput.clearCache();
        this.fileManager.classOutput.clearCache();
        this.fileManager.sourceOutput.clearCache();
        if (this.fileManager.classPath != null) {
            this.fileManager.classPath.clearCache();
        }
        this.processors.clear();
        return ok ? Collections.emptyList() : errors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ReadFileSystem<?> sourcePath;
        private ReadWriteFileSystem<?> classOutput;
        private ReadWriteFileSystem<?> sourceOutput;
        private List<SimpleFileSystem<?>> classPaths;
        private Processor processor;

        private Builder(ReadFileSystem<?> sourcePath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput, List<SimpleFileSystem<?>> classPaths) {
            this.sourcePath = sourcePath;
            this.sourceOutput = sourceOutput;
            this.classOutput = classOutput;
            this.classPaths = classPaths;
            this.processor = null;
        }

        public Builder classOutput(ReadWriteFileSystem<?> classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder output(ReadWriteFileSystem<?> output) {
            this.sourceOutput = output;
            this.classOutput = this.sourceOutput;
            return this;
        }

        public Builder sourcePath(ReadFileSystem<?> sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public Builder sourceOutput(ReadWriteFileSystem<?> sourceOutput) {
            this.sourceOutput = sourceOutput;
            return this;
        }

        public Builder addClassPath(ReadFileSystem<?> classPath) {
            this.classPaths.add(classPath);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder addClassPath(Class<?> type) throws URISyntaxException, IOException {
            URL url = type.getProtectionDomain().getCodeSource().getLocation();
            if (!url.getProtocol().equals("file")) throw new UnsupportedOperationException("Cannot handle path url " + url);
            File f = new File(url.toURI());
            if (f.isDirectory()) {
                this.classPaths.add(new DiskFileSystem(f));
                return this;
            } else {
                if (!f.isFile() || !f.getName().endsWith(".jar")) throw new UnsupportedOperationException("Cannot handle path url " + url);
                this.classPaths.add(new JarFileSystem(new JarFile(f)));
            }
            return this;
        }

        public Builder processor(Processor processor) {
            this.processor = processor;
            return this;
        }

        public Compiler build() {
            if (this.sourcePath == null) {
                throw new IllegalStateException("No null source path");
            }
            if (this.classOutput == null) {
                throw new IllegalStateException("No null class output");
            }
            if (this.sourceOutput == null) {
                throw new IllegalStateException("No null source output");
            }
            Compiler compiler = new Compiler(this.sourcePath, this.classPaths, this.sourceOutput, this.classOutput);
            if (this.processor != null) {
                compiler.addAnnotationProcessor(this.processor);
            }
            return compiler;
        }
    }
}

