/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.juzu.Action;
import org.juzu.Application;
import org.juzu.Path;
import org.juzu.Resource;
import org.juzu.View;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.processor.ModelHandler;
import org.juzu.impl.model.processor.ProcessingContext;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelProcessor
extends BaseProcessor {
    private static final Class<?>[] annotationTypes = new Class[]{View.class, Action.class, Resource.class, Path.class, Application.class};
    private ModelHandler model;
    private Set<TypeElement> annotations;
    Filer filer;
    private int index;
    private final Logger log = BaseProcessor.getLogger(this.getClass());
    private ProcessingContext context;

    @Override
    protected void doInit(ProcessingEnvironment processingEnv) {
        HashSet<TypeElement> annotations = new HashSet<TypeElement>();
        for (Class<?> c : annotationTypes) {
            annotations.add(processingEnv.getElementUtils().getTypeElement(c.getName()));
        }
        this.filer = processingEnv.getFiler();
        this.annotations = annotations;
        this.index = 0;
        this.context = new ProcessingContext(processingEnv);
        this.log.log("Using processing nev " + processingEnv.getClass().getName());
    }

    protected abstract ModelHandler createHandler();

    @Override
    protected ErrorCode decode(String key) {
        for (CompilationErrorCode c : CompilationErrorCode.values()) {
            if (!c.getKey().equals(key)) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) return;
        if (roundEnv.processingOver()) {
            this.log.log("APT processing over");
            this.log.log("Passivating model");
            this.model.prePassivate();
            ObjectOutputStream out = null;
            try {
                try {
                    FileObject file = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "model2.ser", new Element[0]);
                    out = new ObjectOutputStream(file.openOutputStream());
                    out.writeObject(this.model);
                    this.model = null;
                }
                catch (IOException e) {
                    this.log.log("Could not passivate model ", e);
                    Object var6_10 = null;
                    Tools.safeClose(out);
                    return;
                }
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                Tools.safeClose(out);
                throw throwable;
            }
            Tools.safeClose(out);
            return;
        }
        this.log.log("Starting APT round #" + this.index);
        if (this.model == null) {
            block19: {
                InputStream in = null;
                try {
                    try {
                        FileObject file = this.filer.getResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "model2.ser");
                        in = file.openInputStream();
                        ObjectInputStream ois = new ObjectInputStream(in);
                        this.model = (ModelHandler)ois.readObject();
                        this.log.log("Loaded model from " + file.toUri());
                    }
                    catch (Exception e) {
                        this.log.log("Created new model");
                        this.model = this.createHandler();
                        Object var8_16 = null;
                        Tools.safeClose(in);
                        break block19;
                    }
                    Object var8_15 = null;
                }
                catch (Throwable throwable) {
                    Object var8_17 = null;
                    Tools.safeClose(in);
                    throw throwable;
                }
                Tools.safeClose(in);
            }
            this.log.log("Activating model");
            this.model.postActivate(this.context);
        }
        Iterator<TypeElement> i$ = this.annotations.iterator();
        block9: while (true) {
            if (!i$.hasNext()) {
                this.log.log("Post processing model");
                this.model.postProcess();
                this.log.log("Ending APT round #" + this.index++);
                return;
            }
            TypeElement annotationElt = i$.next();
            Iterator<? extends Element> i$2 = roundEnv.getElementsAnnotatedWith(annotationElt).iterator();
            block10: while (true) {
                AnnotationMirror annotationMirror;
                if (!i$2.hasNext()) continue block9;
                Element element = i$2.next();
                if (element.getAnnotation(Generated.class) != null) continue;
                Iterator<? extends AnnotationMirror> i$3 = element.getAnnotationMirrors().iterator();
                do {
                    if (!i$3.hasNext()) continue block10;
                } while (!((Object)(annotationMirror = i$3.next()).getAnnotationType().asElement()).equals(annotationElt));
                String annotationName = annotationElt.getSimpleName().toString();
                HashMap<String, Object> annotationValues = new HashMap<String, Object>();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    String m = entry.getKey().getSimpleName().toString();
                    Object value = entry.getValue().getValue();
                    annotationValues.put(m, value);
                }
                String annotationFQN = annotationElt.getQualifiedName().toString();
                if (annotationFQN.equals("org.juzu.View") || annotationFQN.equals("org.juzu.Action") || annotationFQN.equals("org.juzu.Resource")) {
                    ExecutableElement executableElt = (ExecutableElement)element;
                    this.log.log("Processing controller method " + executableElt + " found on type " + executableElt.getEnclosingElement() + " annotated by " + annotationMirror);
                    this.model.processControllerMethod(executableElt, annotationName, annotationValues);
                    continue;
                }
                if (annotationFQN.equals("org.juzu.Path")) {
                    if (element instanceof VariableElement) {
                        VariableElement variableElt = (VariableElement)element;
                        this.log.log("Processing template declaration " + variableElt.getEnclosingElement() + "#" + variableElt + " annotated by " + annotationMirror);
                        this.model.processDeclarationTemplate(variableElt, annotationName, annotationValues);
                        continue;
                    }
                    if (!(element instanceof TypeElement)) throw new CompilationException(element, (ErrorCode)CompilationErrorCode.ANNOTATION_UNSUPPORTED, new Object[0]);
                    continue;
                }
                if (!annotationFQN.equals("org.juzu.Application")) continue;
                this.log.log("Processing application " + element + " annotated by " + annotationMirror);
                this.model.processApplication((PackageElement)element, annotationName, annotationValues);
            }
            break;
        }
    }
}

