/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs;

import java.io.IOException;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadWriteFileSystem<P>
extends ReadFileSystem<P> {
    public final P makeFile(Iterable<String> path, String name) throws IOException {
        return this.makeFile(this.getRoot(), path, name);
    }

    public final P makeFile(P dir, Iterable<String> path, String name) throws IllegalArgumentException, IOException {
        P child = this.getChild(dir = this.makeDir(dir, path), name);
        if (child == null) {
            return this.addFile(dir, name);
        }
        if (this.isFile(child)) {
            return child;
        }
        throw new UnsupportedOperationException("handle me gracefully");
    }

    public final P makeDir(Iterable<String> path) throws IOException {
        return this.makeDir(this.getRoot(), path);
    }

    public final P makeDir(P dir, Iterable<String> path) throws IllegalArgumentException, IOException {
        if (!this.isDir(dir)) {
            throw new IllegalArgumentException("Dir is not an effective dir");
        }
        for (String name : path) {
            P child = this.getChild(dir, name);
            if (child == null) {
                dir = this.addDir(dir, name);
                continue;
            }
            if (this.isDir(child)) {
                dir = child;
                continue;
            }
            throw new UnsupportedOperationException("handle me gracefully");
        }
        return dir;
    }

    public abstract P addDir(P var1, String var2) throws IOException;

    public abstract P addFile(P var1, String var2) throws IOException;

    public abstract void setContent(P var1, Content var2) throws IOException;
}

