/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Named;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.juzu.impl.inject.ScopeController;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.guice.BeanBinding;
import org.juzu.impl.spi.inject.guice.GuiceBootstrap;
import org.juzu.impl.spi.inject.guice.GuiceScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceManager
implements InjectManager<javax.inject.Provider, Object> {
    private Injector injector;
    private final ClassLoader classLoader;
    private final Map<String, Key<?>> nameMap;

    public GuiceManager(final GuiceBootstrap bootstrap) {
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                for (Scope scope : bootstrap.scopes) {
                    this.bindScope(scope.getAnnotationType(), new GuiceScope(scope, ScopeController.INSTANCE));
                }
                for (BeanBinding beanBinding : bootstrap.bindings) {
                    AnnotatedBindingBuilder a = this.bind(beanBinding.type);
                    Object b = beanBinding.qualifier != null ? a.annotatedWith(beanBinding.qualifier) : a;
                    Object c = beanBinding.provider != null ? b.toProvider(beanBinding.provider) : (beanBinding.qualifier != null ? (beanBinding.implementationType != null ? b.to(beanBinding.implementationType) : b.to(beanBinding.type)) : (beanBinding.implementationType != null ? b.to(beanBinding.implementationType) : b));
                    if (beanBinding.scope == null) continue;
                    c.in(beanBinding.scope.annotationType());
                }
                for (Map.Entry entry : bootstrap.providers.entrySet()) {
                    final javax.inject.Provider provider = (javax.inject.Provider)entry.getValue();
                    AnnotatedBindingBuilder bind = this.bind((Class)entry.getKey());
                    Provider<Object> guiceProvider = new Provider<Object>(){

                        public Object get() {
                            return provider.get();
                        }
                    };
                    bind.toProvider((Provider)guiceProvider);
                }
                this.bind(InjectManager.class).toInstance((Object)GuiceManager.this);
                for (Map.Entry entry : bootstrap.singletons.entrySet()) {
                    this.bind((Class)entry.getKey(), entry.getValue());
                }
            }

            private <T> void bind(Class<T> clazz, T instance) {
                this.bind(clazz).toInstance(instance);
            }
        };
        HashMap nameMap = new HashMap();
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        for (Key key : injector.getBindings().keySet()) {
            Class annotationType = key.getAnnotationType();
            if (annotationType == null || !Named.class.isAssignableFrom(annotationType)) continue;
            Named named = (Named)key.getAnnotation();
            nameMap.put(named.value(), key);
        }
        this.injector = injector;
        this.nameMap = nameMap;
        this.classLoader = bootstrap.classLoader;
    }

    @Override
    public String getImplementation() {
        return "inject/guice";
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public javax.inject.Provider resolveBean(Class<?> type) {
        return this.injector.getProvider(type);
    }

    @Override
    public javax.inject.Provider resolveBean(String name) {
        Key<?> key = this.nameMap.get(name);
        return key != null ? this.injector.getProvider(key) : null;
    }

    @Override
    public Object create(javax.inject.Provider bean) throws InvocationTargetException {
        try {
            return bean.get();
        }
        catch (ProvisionException e) {
            throw new InvocationTargetException(e.getCause());
        }
    }

    @Override
    public void release(Object instance) {
    }

    @Override
    public Object get(javax.inject.Provider bean, Object instance) {
        return instance;
    }
}

