/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.template.gtmpl;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.juzu.impl.spi.template.TemplateStub;
import org.juzu.impl.spi.template.gtmpl.BaseScript;
import org.juzu.impl.spi.template.gtmpl.Foo;
import org.juzu.template.TemplateExecutionException;
import org.juzu.template.TemplateRenderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroovyTemplateStub
extends TemplateStub {
    protected final String templateId;
    private Class<?> scriptClass;
    private HashMap<Integer, Foo> locationTable;

    protected GroovyTemplateStub() {
        String name = this.getClass().getName();
        this.templateId = name.substring(0, name.length() - 1);
    }

    public GroovyTemplateStub(String templateId) {
        this.templateId = templateId;
        this.scriptClass = null;
        this.locationTable = null;
    }

    private Class<?> getScriptClass() {
        if (this.scriptClass == null) {
            CompilerConfiguration config = new CompilerConfiguration();
            config.setScriptBaseClass(BaseScript.class.getName());
            String script = this.getScript();
            GroovyCodeSource gcs = new GroovyCodeSource((InputStream)new ByteArrayInputStream(script.getBytes()), "myscript", "/groovy/shell");
            GroovyClassLoader loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
            try {
                this.scriptClass = loader.parseClass(gcs, false);
                Class<?> constants = this.scriptClass.getClassLoader().loadClass("Constants");
                this.locationTable = (HashMap)constants.getField("TABLE").get(null);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("handle me gracefully", e);
            }
        }
        return this.scriptClass;
    }

    public abstract String getScript();

    public String getClassName() {
        return this.getScriptClass().getName();
    }

    @Override
    public void render(TemplateRenderContext renderContext) throws TemplateExecutionException, IOException {
        Class<?> scriptClass = this.getScriptClass();
        BaseScript script = (BaseScript)InvokerHelper.createScript(scriptClass, (Binding)(renderContext.getAttributes() != null ? new Binding(renderContext.getAttributes()) : new Binding()));
        script.init(renderContext);
        try {
            script.run();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw this.buildRuntimeException(e);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw this.buildRuntimeException(e);
        }
    }

    private TemplateExecutionException buildRuntimeException(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        Foo firstItem = null;
        for (int i = 0; i < trace.length; ++i) {
            int templateLineNumber;
            StackTraceElement element = trace[i];
            if (!element.getClassName().equals(this.scriptClass.getName())) continue;
            int lineNumber = element.getLineNumber();
            Foo item = this.locationTable.get(lineNumber);
            if (item != null) {
                templateLineNumber = item.getPosition().getLine();
                if (firstItem == null) {
                    firstItem = item;
                }
            } else {
                templateLineNumber = -1;
            }
            trace[i] = element = new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), templateLineNumber);
        }
        t.setStackTrace(trace);
        if (firstItem != null) {
            return new TemplateExecutionException(this.templateId, firstItem.getPosition(), firstItem.getValue(), t);
        }
        return new TemplateExecutionException(this.templateId, null, null, t);
    }
}

