/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.template.compiler;

import java.util.Map;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.compiler.CompilationPhase;
import org.juzu.impl.template.compiler.ExtendedTagHandler;
import org.juzu.impl.template.compiler.ProcessContext;
import org.juzu.impl.template.compiler.Template;
import org.juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPhase
extends CompilationPhase {
    private final Map<String, Template> templates;
    private final ProcessContext context;
    private String originPath;

    public ProcessPhase(ProcessContext context, Map<String, Template> templates) {
        this.templates = templates;
        this.context = context;
    }

    public Map<String, Template> getTemplates() {
        return this.templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template resolveTemplate(String path) throws CompilationException {
        boolean initial;
        if (this.originPath == null) {
            this.originPath = path;
            initial = true;
        } else {
            initial = false;
        }
        try {
            Template template = this.templates.get(path);
            if (template == null && (template = this.context.resolveTemplate(this.originPath, path)) != null) {
                this.templates.put(path, template);
                ASTNode.Template templateAST = template.getAST();
                this.doAttribute(templateAST);
                this.doProcess(template, templateAST);
                this.doResolve(template, templateAST);
                this.doUnattribute(templateAST);
            }
            Template template2 = template;
            Object var6_5 = null;
            if (initial) {
                this.originPath = null;
            }
            return template2;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (!initial) break block6;
                this.originPath = null;
            }
            throw throwable;
        }
    }

    private void doProcess(Template template, ASTNode<?> node) throws CompilationException {
        block4: {
            block3: {
                if (!(node instanceof ASTNode.Template)) break block3;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doProcess(template, child);
                }
                break block4;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block4;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.get(nodeTag);
            if (handler instanceof ExtendedTagHandler) {
                ((ExtendedTagHandler)handler).process(this, nodeTag, template);
            }
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doProcess(template, child);
            }
        }
    }

    private void doResolve(Template template, ASTNode<?> node) throws CompilationException {
        block4: {
            block3: {
                if (!(node instanceof ASTNode.Template)) break block3;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doResolve(template, child);
                }
                break block4;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block4;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.get(nodeTag);
            if (handler instanceof ExtendedTagHandler) {
                ((ExtendedTagHandler)handler).compile(this, nodeTag, template);
            }
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doResolve(template, child);
            }
        }
    }
}

