/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.portlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import org.juzu.impl.application.ApplicationBootstrap;
import org.juzu.impl.application.ApplicationException;
import org.juzu.impl.application.InternalApplicationContext;
import org.juzu.impl.compiler.CompilationError;
import org.juzu.impl.compiler.Compiler;
import org.juzu.impl.fs.Change;
import org.juzu.impl.fs.FileSystemScanner;
import org.juzu.impl.model.processor.MainProcessor;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.fs.classloader.ClassLoaderFileSystem;
import org.juzu.impl.spi.fs.jar.JarFileSystem;
import org.juzu.impl.spi.fs.ram.RAMFileSystem;
import org.juzu.impl.spi.fs.war.WarFileSystem;
import org.juzu.impl.spi.inject.InjectBootstrap;
import org.juzu.impl.spi.inject.cdi.CDIBootstrap;
import org.juzu.impl.spi.inject.spring.SpringBootstrap;
import org.juzu.impl.spi.request.portlet.PortletActionBridge;
import org.juzu.impl.spi.request.portlet.PortletRenderBridge;
import org.juzu.impl.spi.request.portlet.PortletResourceBridge;
import org.juzu.impl.utils.DevClassLoader;
import org.juzu.impl.utils.JSON;
import org.juzu.impl.utils.Tools;
import org.juzu.impl.utils.TrimmingException;
import org.juzu.metadata.ApplicationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuzuPortlet
implements Portlet,
ResourceServingPortlet {
    private static final String[] CONFIG_PATH = new String[]{"org", "juzu", "config.json"};
    private InternalApplicationContext applicationContext;
    private boolean prod;
    private PortletConfig config;
    private FileSystemScanner<String> devScanner;
    private List<URL> jarURLs;
    private ClassLoaderFileSystem classLoaderFS;

    public void init(PortletConfig config) throws PortletException {
        try {
            String runMode = config.getInitParameter("juzu.run_mode");
            runMode = runMode == null ? "prod" : runMode.trim().toLowerCase();
            ArrayList<URL> jars = new ArrayList<URL>();
            WarFileSystem bah = WarFileSystem.create(config.getPortletContext(), "/WEB-INF/lib/");
            Iterator<String> i = bah.getChildren(bah.getRoot());
            while (i.hasNext()) {
                String s = i.next();
                URL url = bah.getURL(s);
                jars.add(url);
            }
            this.config = config;
            this.prod = !"dev".equals(runMode);
            this.jarURLs = jars;
            Collection<CompilationError> errors = this.boot();
            if (errors != null && errors.size() > 0) {
                System.out.println("Error when compiling application " + errors);
            }
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private Collection<CompilationError> boot() throws PortletException {
        if (this.prod) {
            if (this.applicationContext == null) {
                try {
                    WarFileSystem fs = WarFileSystem.create(this.config.getPortletContext(), "/WEB-INF/classes/");
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    this.boot(fs, cl);
                }
                catch (Exception e) {
                    throw new PortletException("Could not find an application to start", (Throwable)e);
                }
            }
            return null;
        }
        try {
            if (this.devScanner != null) {
                Map<String, Change> changes = this.devScanner.scan();
                if (changes.size() > 0) {
                    System.out.println("[" + this.config.getPortletName() + "] Detected changes : " + changes);
                    this.applicationContext = null;
                } else {
                    System.out.println("[" + this.config.getPortletName() + "] No changes detected");
                }
            }
            if (this.applicationContext == null) {
                System.out.println("[" + this.config.getPortletName() + "] Building application");
                if (this.classLoaderFS == null) {
                    DevClassLoader devCL = new DevClassLoader(Thread.currentThread().getContextClassLoader());
                    this.classLoaderFS = new ClassLoaderFileSystem(devCL);
                }
                WarFileSystem fs = WarFileSystem.create(this.config.getPortletContext(), "/WEB-INF/src/");
                RAMFileSystem classes = new RAMFileSystem();
                Compiler compiler = new Compiler(fs, this.classLoaderFS, classes, classes);
                compiler.addAnnotationProcessor(new MainProcessor());
                List<CompilationError> res = compiler.compile();
                if (res.isEmpty()) {
                    URLClassLoader cl2 = new URLClassLoader(new URL[]{classes.getURL()}, this.classLoaderFS.getClassLoader());
                    this.boot(classes, cl2);
                    this.devScanner = new FileSystemScanner<String>(fs);
                    this.devScanner.scan();
                    System.out.println("[" + this.config.getPortletName() + "] Dev mode scanner monitoring " + fs.getFile(fs.getRoot()));
                    return Collections.emptyList();
                }
                return res;
            }
            return null;
        }
        catch (Exception e) {
            throw e instanceof PortletException ? (PortletException)e : new PortletException((Throwable)e);
        }
    }

    private <P, D> void boot(ReadFileSystem<P> classes, ClassLoader cl) throws Exception {
        URL configurationURL;
        InjectBootstrap injectBootstrap;
        Object f = classes.getPath(CONFIG_PATH);
        URL url = classes.getURL(f);
        String s = Tools.read(url);
        JSON json = (JSON)JSON.parse(s);
        String appName = this.config.getInitParameter("juzu.app_name");
        String fqn = null;
        if (appName != null) {
            fqn = (String)json.get(appName.trim());
        } else {
            for (String a : json.names()) {
                String b = json.getString(a);
                if (a.length() <= 0 || b.length() <= 0) continue;
                fqn = b;
                break;
            }
        }
        if (fqn == null) {
            throw new Exception("Could not find an application to start " + json);
        }
        Class<?> clazz = cl.loadClass(fqn);
        Field field = clazz.getDeclaredField("DESCRIPTOR");
        ApplicationDescriptor descriptor = (ApplicationDescriptor)field.get(null);
        URL mainURL = null;
        for (URL jarURL : this.jarURLs) {
            URL configURL = new URL("jar:" + jarURL.toString() + "!/org/juzu/impl/application/ApplicationBootstrap.class");
            try {
                configURL.openStream();
                mainURL = jarURL;
                break;
            }
            catch (IOException ignore) {
            }
        }
        if (mainURL == null) {
            throw new PortletException("Cannot find juzu jar among " + this.jarURLs);
        }
        JarFileSystem libs = new JarFileSystem(new JarFile(new File(mainURL.toURI())));
        String inject = this.config.getInitParameter("juzu.inject");
        if (inject == null) {
            inject = "weld";
        }
        if ("weld".equals(inject = inject.trim().toLowerCase())) {
            injectBootstrap = new CDIBootstrap();
        } else if ("spring".equals(inject)) {
            injectBootstrap = new SpringBootstrap();
        } else {
            throw new PortletException("unrecognized inject vendor " + inject);
        }
        System.out.println("[" + this.config.getPortletName() + "] Using injection " + injectBootstrap.getClass().getName());
        injectBootstrap.addFileSystem(classes);
        injectBootstrap.addFileSystem(libs);
        injectBootstrap.setClassLoader(cl);
        if (injectBootstrap instanceof SpringBootstrap && (configurationURL = this.config.getPortletContext().getResource("/WEB-INF/spring.xml")) != null) {
            ((SpringBootstrap)injectBootstrap).setConfigurationURL(configurationURL);
        }
        ApplicationBootstrap bootstrap = new ApplicationBootstrap(injectBootstrap, descriptor);
        System.out.println("[" + this.config.getPortletName() + "] Starting " + descriptor.getName());
        bootstrap.start();
        this.applicationContext = bootstrap.getContext();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            this.applicationContext.invoke(new PortletActionBridge(request, response));
        }
        catch (ApplicationException e) {
            throw new PortletException(e.getCause());
        }
    }

    private void purgeSession(PortletRequest req) {
        PortletSession session = req.getPortletSession();
        for (String key : new HashSet(session.getAttributeMap().keySet())) {
            session.removeAttribute(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(final RenderRequest request, final RenderResponse response) throws PortletException, IOException {
        Collection<CompilationError> errors = this.boot();
        if (errors != null && !errors.isEmpty()) {
            this.renderErrors(response.getWriter(), errors);
            return;
        }
        if (errors != null) {
            this.purgeSession((PortletRequest)request);
        }
        try {
            try {
                TrimmingException.invoke(new TrimmingException.Callback(){

                    public void call() throws Throwable {
                        try {
                            PortletRenderBridge bridge = new PortletRenderBridge(request, response, !JuzuPortlet.this.prod);
                            JuzuPortlet.this.applicationContext.invoke(bridge);
                            bridge.commit();
                        }
                        catch (ApplicationException e) {
                            throw e.getCause();
                        }
                    }
                });
            }
            catch (TrimmingException e) {
                if (this.prod) {
                    throw new PortletException(e.getSource());
                }
                this.renderThrowable(response.getWriter(), e);
                Object var6_5 = null;
                PortletSession session = request.getPortletSession(false);
                if (session == null) return;
                session.removeAttribute("org.juzu.flash_scope");
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PortletSession session = request.getPortletSession(false);
            if (session == null) throw throwable;
            session.removeAttribute("org.juzu.flash_scope");
            throw throwable;
        }
        PortletSession session = request.getPortletSession(false);
        if (session == null) return;
        session.removeAttribute("org.juzu.flash_scope");
    }

    public void serveResource(final ResourceRequest request, final ResourceResponse response) throws PortletException, IOException {
        Collection<CompilationError> errors = this.boot();
        if (errors == null || errors.isEmpty()) {
            if (errors != null) {
                this.purgeSession((PortletRequest)request);
            }
            try {
                TrimmingException.invoke(new TrimmingException.Callback(){

                    public void call() throws Throwable {
                        try {
                            PortletResourceBridge bridge = new PortletResourceBridge(request, response, !JuzuPortlet.this.prod);
                            JuzuPortlet.this.applicationContext.invoke(bridge);
                            bridge.commit();
                        }
                        catch (ApplicationException e) {
                            throw e.getCause();
                        }
                    }
                });
            }
            catch (TrimmingException e) {
                response.setProperty("portlet.http-status-code", "500");
                this.logThrowable(e);
                if (!this.prod) {
                    PrintWriter writer = response.getWriter();
                    writer.print("<html>\n");
                    writer.print("<head>\n");
                    writer.print("</head>\n");
                    writer.print("<body>\n");
                    this.renderThrowable(writer, e);
                    writer.print("</body>\n");
                }
            }
        } else {
            response.setProperty("portlet.http-status-code", "500");
            this.logErrors(errors);
            if (!this.prod) {
                PrintWriter writer = response.getWriter();
                writer.print("<html>\n");
                writer.print("<head>\n");
                writer.print("</head>\n");
                writer.print("<body>\n");
                this.renderErrors(writer, errors);
                writer.print("</body>\n");
            }
        }
    }

    private void sendJuzuCSS(PrintWriter writer) throws IOException {
        URL cssURL = JuzuPortlet.class.getResource("juzu.css");
        String css = Tools.read(cssURL);
        css = css.replace("\"", "\\\"");
        css = css.replace("'", "\\'");
        css = css.replace("\n", "\\n");
        writer.append("<script type='text/javascript'>\n");
        writer.append("var styleElement = document.createElement('style');\n");
        writer.append("var css = '");
        writer.append(css);
        writer.append("';\n");
        writer.append("styleElement.type = 'text/css';\n");
        writer.append("if (styleElement.styleSheet) {;\n");
        writer.append("styleElement.styleSheet.cssText = css;\n");
        writer.append("} else {\n");
        writer.append("styleElement.appendChild(document.createTextNode(css));\n");
        writer.append("}\n");
        writer.append("document.getElementsByTagName(\"head\")[0].appendChild(styleElement);\n");
        writer.append("</script>\n");
    }

    private void logThrowable(Throwable t) {
        this.config.getPortletContext().log(t.getMessage(), t);
    }

    private void logErrors(Collection<CompilationError> errors) {
        StringBuilder sb = new StringBuilder("Compilation errors:\n");
        for (CompilationError error : errors) {
            if (error.getSourceFile() != null) {
                sb.append(error.getSourceFile().getAbsolutePath());
            } else {
                sb.append(error.getSource());
            }
            sb.append(':').append(error.getLocation().getLine()).append(':').append(error.getMessage()).append('\n');
        }
        this.config.getPortletContext().log(sb.toString());
    }

    private void renderThrowable(PrintWriter writer, Throwable t) throws PortletException, IOException {
        StackTraceElement[] trace;
        int size = 0;
        for (StackTraceElement element : trace = t.getStackTrace()) {
            if (element.getClassName().equals(JuzuPortlet.class.getName())) break;
            ++size;
        }
        StackTraceElement[] ourTrace = new StackTraceElement[size];
        System.arraycopy(trace, 0, ourTrace, 0, ourTrace.length);
        t.setStackTrace(ourTrace);
        this.sendJuzuCSS(writer);
        final AtomicBoolean open = new AtomicBoolean(false);
        PrintWriter formatter = new PrintWriter(writer){

            public void println(Object x) {
                if (open.get()) {
                    super.append("</ul></pre>");
                }
                super.append("<div class=\"juzu-message\">");
                super.append(String.valueOf(x));
                super.append("</div>");
                open.set(false);
            }

            public void println(String x) {
                if (!open.get()) {
                    super.append("<pre><ul>");
                    open.set(true);
                }
                super.append("<li><span>");
                super.append(x);
                super.append("</span></li>");
            }

            public void println() {
            }
        };
        writer.append("<div class=\"juzu\">");
        writer.append("<div class=\"juzu-box\">");
        t.printStackTrace(formatter);
        if (open.get()) {
            writer.append("</ul></pre>");
        }
        writer.append("</div>");
        writer.append("</div>");
    }

    private void renderErrors(PrintWriter writer, Collection<CompilationError> errors) throws PortletException, IOException {
        this.sendJuzuCSS(writer);
        writer.append("<div class=\"juzu\">");
        for (CompilationError error : errors) {
            writer.append("<div class=\"juzu-box\">");
            writer.append("<div class=\"juzu-message\">").append(error.getMessage()).append("</div>");
            File source = error.getSourceFile();
            if (source != null) {
                int line = error.getLocation().getLine();
                int from = line - 2;
                int to = line + 3;
                BufferedReader reader = new BufferedReader(new FileReader(source));
                int count = 1;
                writer.append("<pre><ol start=\"").append(String.valueOf(from)).append("\">");
                String s = reader.readLine();
                while (s != null) {
                    if (count >= from && count < to) {
                        if (count == line) {
                            writer.append("<li><span class=\"error\">").append(s).append("</span></li>");
                        } else {
                            writer.append("<li><span>").append(s).append("</span></li>");
                        }
                    }
                    ++count;
                    s = reader.readLine();
                }
                writer.append("</ol></pre>");
            }
            writer.append("</div>");
        }
        writer.append("</div>");
    }

    public void destroy() {
    }
}

