/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.juzu.impl.fs.Visitor;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadFileSystem<P> {
    public static final int DIR = 0;
    public static final int FILE = 1;
    public static final int PATH = 2;
    private final Charset encoding = Charset.defaultCharset();

    public static <S, D> void copy(ReadFileSystem<S> src, ReadWriteFileSystem<D> dst) throws IOException {
        ReadFileSystem.copy(src, src.getRoot(), dst, dst.getRoot());
    }

    private static <S, D> int kind(ReadFileSystem<S> src, S srcPath, ReadWriteFileSystem<D> dst, D dstPath) throws IOException {
        return (src.isDir(srcPath) ? 1 : 0) + (dst.isDir(dstPath) ? 2 : 0);
    }

    public static <S, D> void copy(ReadFileSystem<S> src, S srcPath, ReadWriteFileSystem<D> dst, D dstPath) throws IOException {
        int kind = ReadFileSystem.kind(src, srcPath, dst, dstPath);
        switch (kind) {
            case 0: {
                dst.setContent(dstPath, src.getContent(srcPath));
                break;
            }
            case 3: {
                Object a;
                String name;
                Object next;
                Iterator<Object> i = dst.getChildren(dstPath);
                block7: while (i.hasNext()) {
                    next = i.next();
                    name = dst.getName(next);
                    a = src.getChild(srcPath, name);
                    if (a == null) {
                        i.remove();
                        continue;
                    }
                    switch (ReadFileSystem.kind(src, a, dst, next)) {
                        case 1: 
                        case 2: {
                            i.remove();
                            continue block7;
                        }
                    }
                    ReadFileSystem.copy(src, a, dst, next);
                }
                i = src.getChildren(srcPath);
                while (i.hasNext()) {
                    next = i.next();
                    name = src.getName(next);
                    a = dst.getChild(dstPath, name);
                    if (a == null) {
                        a = src.isDir(next) ? dst.addDir(dstPath, name) : dst.addFile(dstPath, name);
                    }
                    ReadFileSystem.copy(src, next, dst, a);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Todo " + kind);
            }
        }
    }

    public final void dump(Appendable appendable) throws IOException {
        this.dump(this.getRoot(), appendable);
    }

    public final void dump(P path, final Appendable appendable) throws IOException {
        final StringBuilder prefix = new StringBuilder();
        this.traverse(path, new Visitor<P>(){

            @Override
            public boolean enterDir(P dir, String name) throws IOException {
                prefix.append(name).append('/');
                return true;
            }

            @Override
            public void file(P file, String name) throws IOException {
                appendable.append(prefix).append(name).append("\n");
            }

            @Override
            public void leaveDir(P dir, String name) throws IOException {
                prefix.setLength(prefix.length() - 1 - name.length());
            }
        });
    }

    public final P getFile(Iterable<String> dirNames, String fileName) throws IOException {
        P child;
        P dir = this.getDir(dirNames);
        if (dir != null && (child = this.getChild(dir, fileName)) != null && this.isFile(child)) {
            return child;
        }
        return null;
    }

    public final P getDir(Iterable<String> names) throws IOException {
        P current = this.getRoot();
        for (String name : names) {
            P child = this.getChild(current, name);
            if (child != null && this.isDir(child)) {
                current = child;
                continue;
            }
            return null;
        }
        return current;
    }

    public final void pathOf(P path, char separator, Appendable appendable) throws IOException {
        if (this.packageOf(path, separator, appendable)) {
            appendable.append(separator);
        }
        String name = this.getName(path);
        appendable.append(name);
    }

    public final boolean packageOf(P path, char separator, Appendable appendable) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        if (this.isDir(path)) {
            P parent = this.getParent(path);
            if (parent == null) {
                return false;
            }
            String name = this.getName(path);
            if (this.packageOf(parent, separator, appendable)) {
                appendable.append(separator);
            }
            appendable.append(name);
            return true;
        }
        return this.packageOf(this.getParent(path), separator, appendable);
    }

    public final Content getContent(String ... names) throws IOException {
        return this.getContent((P)Arrays.asList(names));
    }

    public final Content getContent(Iterable<String> names) throws IOException {
        P path = this.getPath(names);
        if (path != null && this.isFile(path)) {
            return this.getContent(path);
        }
        return null;
    }

    public final P getPath(String ... names) throws IOException {
        return this.getPath(Arrays.asList(names));
    }

    public final P getPath(Iterable<String> names) throws IOException {
        P current = this.getRoot();
        for (String name : names) {
            if (this.isDir(current)) {
                P child = this.getChild(current, name);
                if (child != null) {
                    current = child;
                    continue;
                }
                return null;
            }
            throw new UnsupportedOperationException("handle me gracefully");
        }
        return current;
    }

    public final int size(final int mode) throws IOException {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode " + mode);
            }
        }
        final AtomicInteger size = new AtomicInteger();
        this.traverse(new Visitor.Default<P>(){

            @Override
            public boolean enterDir(P dir, String name) throws IOException {
                if (mode == 2 || mode == 0) {
                    size.incrementAndGet();
                }
                return true;
            }

            @Override
            public void file(P file, String name) throws IOException {
                if (mode == 2 || mode == 1) {
                    size.incrementAndGet();
                }
            }
        });
        return size.get();
    }

    public final void traverse(P path, Visitor<P> visitor) throws IOException {
        String name = this.getName(path);
        if (this.isDir(path)) {
            if (visitor.enterDir(path, name)) {
                Iterator<P> i = this.getChildren(path);
                while (i.hasNext()) {
                    P child = i.next();
                    this.traverse(child, visitor);
                }
                visitor.leaveDir(path, name);
            }
        } else {
            visitor.file(path, name);
        }
    }

    public final void traverse(Visitor<P> visitor) throws IOException {
        this.traverse(this.getRoot(), visitor);
    }

    public final URL getURL() throws IOException {
        P root = this.getRoot();
        return this.getURL(root);
    }

    protected ReadFileSystem() {
    }

    public final Charset getEncoding() {
        return this.encoding;
    }

    public abstract boolean equals(P var1, P var2);

    public abstract String getName(P var1) throws IOException;

    public abstract P getRoot() throws IOException;

    public abstract P getParent(P var1) throws IOException;

    public abstract Iterator<P> getChildren(P var1) throws IOException;

    public abstract P getChild(P var1, String var2) throws IOException;

    public abstract boolean isDir(P var1) throws IOException;

    public abstract boolean isFile(P var1) throws IOException;

    public abstract Content getContent(P var1) throws IOException;

    public abstract long getLastModified(P var1) throws IOException;

    public abstract URL getURL(P var1) throws IOException;

    public abstract File getFile(P var1) throws IOException;
}

