/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.cdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.juzu.impl.inject.ScopeController;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.inject.InjectBootstrap;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.cdi.CDIManager;
import org.juzu.impl.spi.inject.cdi.weld.WeldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIBootstrap
extends InjectBootstrap {
    private Set<Scope> scopes = new HashSet<Scope>();
    private ClassLoader classLoader;
    private List<ReadFileSystem<?>> fileSystems = new ArrayList();
    private Map<Class<?>, Object> singletons = new HashMap();
    private Set<Class<?>> beans = new HashSet();

    @Override
    public <T> InjectBootstrap declareBean(Class<T> type, Class<? extends T> implementationType) {
        this.beans.add(implementationType != null ? implementationType : type);
        return this;
    }

    @Override
    public <T> InjectBootstrap declareProvider(Class<T> type, Class<? extends Provider<T>> provider) {
        this.beans.add(provider);
        return this;
    }

    @Override
    public <P> InjectBootstrap addFileSystem(ReadFileSystem<P> fs) {
        this.fileSystems.add(fs);
        return this;
    }

    @Override
    public InjectBootstrap addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public InjectBootstrap setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <T> InjectBootstrap bindSingleton(Class<T> type, T instance) {
        this.singletons.put(type, instance);
        return this;
    }

    public InjectManager<?, ?> create() throws Exception {
        WeldContainer container = new WeldContainer(this.classLoader, ScopeController.INSTANCE, this.scopes);
        for (ReadFileSystem<?> fs : this.fileSystems) {
            container.addFileSystem(fs);
        }
        return new CDIManager(container, this.singletons, this.beans);
    }
}

