/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.juzu.impl.inject.ScopeController;
import org.juzu.impl.request.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContextImpl
implements Context {
    private final ScopeController controller;
    private final Class<? extends Annotation> scopeType;
    private final Scope scope;

    ContextImpl(ScopeController controller, Scope scope, Class<? extends Annotation> scopeType) {
        this.controller = controller;
        this.scopeType = scopeType;
        this.scope = scope;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        try {
            Object o = this.controller.get(this.scope, contextual);
            if (o == null && creationalContext != null) {
                o = contextual.create(creationalContext);
                this.controller.put(this.scope, contextual, o);
            }
            return (T)o;
        }
        catch (IllegalStateException e) {
            throw new ContextNotActiveException("Context not active for scope=" + (Object)((Object)this.scope) + " contextual=" + contextual, (Throwable)e);
        }
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.controller.isActive(this.scope);
    }
}

