/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.guice;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.inject.InjectBootstrap;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.guice.BeanBinding;
import org.juzu.impl.spi.inject.guice.GuiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceBootstrap
extends InjectBootstrap {
    final List<BeanBinding> bindings = new ArrayList<BeanBinding>();
    final Set<Scope> scopes = new HashSet<Scope>();
    final Map<Class<?>, Object> singletons = new HashMap();
    ClassLoader classLoader;

    @Override
    public <T> InjectBootstrap declareBean(Class<T> type, Class<? extends T> implementationType) {
        this.add(type, implementationType, null);
        return this;
    }

    @Override
    public <T> InjectBootstrap declareProvider(Class<T> type, Class<? extends Provider<T>> provider) {
        this.add(type, null, provider);
        return this;
    }

    private <T> void add(Class<T> type, Class<? extends T> implementationType, Class<? extends Provider<T>> provider) {
        Annotation qualifier = null;
        Annotation scope = null;
        Class<Object> foo = implementationType != null ? implementationType : type;
        for (Annotation ann : foo.getDeclaredAnnotations()) {
            if (ann.annotationType().getAnnotation(Qualifier.class) != null) {
                qualifier = ann;
            }
            if (ann.annotationType().getAnnotation(javax.inject.Scope.class) == null) continue;
            scope = ann;
        }
        this.bindings.add(new BeanBinding<T>(type, implementationType, qualifier, scope, provider));
    }

    @Override
    public <P> InjectBootstrap addFileSystem(ReadFileSystem<P> fs) {
        return this;
    }

    @Override
    public InjectBootstrap addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public InjectBootstrap setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <T> InjectBootstrap bindSingleton(Class<T> type, T instance) {
        this.singletons.put(type, instance);
        return this;
    }

    public InjectManager<?, ?> create() {
        return new GuiceManager(this);
    }
}

