/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.request.portlet;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import org.juzu.impl.spi.request.RequestBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletRequestBridge<Rq extends PortletRequest, Rs extends PortletResponse>
implements RequestBridge {
    protected final Rq request;
    protected final Rs response;
    protected final String methodId;
    protected final Map<String, String[]> parameters;

    PortletRequestBridge(Rq request, Rs response) {
        HashMap<String, String[]> parameters = request.getParameterMap();
        String methodId = request.getParameter("op");
        if (methodId != null) {
            parameters = new HashMap<String, String[]>(parameters);
            parameters.remove("op");
        }
        this.request = request;
        this.response = response;
        this.methodId = methodId;
        this.parameters = parameters;
    }

    @Override
    public String getMethodId() {
        return this.methodId;
    }

    @Override
    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public void setFlashValue(Object key, Object value) {
        if (value == null) {
            this.getFlashContext().remove(key);
        } else {
            this.getFlashContext().put(key, value);
        }
    }

    @Override
    public Object getFlashValue(Object key) {
        Map<Object, Object> flash = this.getFlashContext();
        return flash != null ? flash.get(key) : null;
    }

    @Override
    public Object getRequestValue(Object key) {
        return this.getRequestContext().get(key);
    }

    @Override
    public void setRequestValue(Object key, Object value) {
        if (value != null) {
            this.getRequestContext().remove(key);
        } else {
            this.getRequestContext().put(key, value);
        }
    }

    private Map<Object, Object> getRequestContext() {
        HashMap store = (HashMap)this.request.getAttribute("org.juzu.request_scope");
        if (store == null) {
            store = new HashMap();
            this.request.setAttribute("org.juzu.request_scope", store);
        }
        return store;
    }

    @Override
    public void setSessionValue(Object key, Object value) {
        if (value == null) {
            this.getSessionContext().remove(key);
        } else {
            this.getSessionContext().put(key, value);
        }
    }

    @Override
    public Object getSessionValue(Object key) {
        return this.getSessionContext().get(key);
    }

    private Map<Object, Object> getSessionContext() {
        PortletSession session = this.request.getPortletSession();
        HashMap store = (HashMap)session.getAttribute("org.juzu.session_scope");
        if (store == null) {
            store = new HashMap();
            session.setAttribute("org.juzu.session_scope", store);
        }
        return store;
    }

    private Map<Object, Object> getFlashContext() {
        PortletSession session = this.request.getPortletSession();
        HashMap store = (HashMap)session.getAttribute("org.juzu.flash_scope");
        if (store == null) {
            store = new HashMap();
            session.setAttribute("org.juzu.flash_scope", store);
        }
        return store;
    }

    @Override
    public Object getIdentityValue(Object key) {
        return null;
    }

    @Override
    public void setIdentityValue(Object key, Object value) {
    }
}

