/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.template;

import org.juzu.text.Location;

public class TemplateExecutionException
extends RuntimeException {
    private final String templateId;
    private final Location location;
    private final String text;

    public TemplateExecutionException(String templateId, Location location, String text, String message, Throwable cause) {
        super(message, cause);
        this.templateId = templateId;
        this.location = location;
        this.text = text;
    }

    public TemplateExecutionException(String templateId, Location location, String text, Throwable cause) {
        super(cause);
        this.templateId = templateId;
        this.location = location;
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Integer getLineNumber() {
        return this.text != null ? Integer.valueOf(this.location.getLine()) : null;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Groovy template exception");
        if (this.location != null) {
            sb.append(" at ").append(this.location);
        }
        if (this.text != null) {
            sb.append(" script ").append(this.text);
        }
        if (this.templateId != null) {
            sb.append(" for template ").append(this.templateId);
        }
        return sb.toString();
    }
}

