/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application;

import java.io.File;
import java.util.List;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.compiler.CompilationError;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ApplicationTestCase
extends AbstractTestCase {
    @Test
    public void testDefaultController() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "default_controller");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.default_controller.Default_controllerApplication");
        Class<?> aClass = compiler.assertClass("application.default_controller.A");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ApplicationTestCase.assertSame(aClass, (Object)desc.getController().getDefault());
    }

    public void _testMethodId() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "method", "id");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.method.id.IdApplication");
        Class<?> aClass = compiler.assertClass("application.method.id.A");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethod a = desc.getController().getMethod(aClass, "a", new Class[0]);
        ControllerMethod b = desc.getController().getMethod(aClass, "b", new Class[0]);
        ControllerMethod c = desc.getController().getMethod(aClass, "c", new Class[0]);
        ApplicationTestCase.assertEquals((String)"foo", (String)a.getId());
        ApplicationTestCase.assertEquals((String)"bar", (String)b.getId());
        ApplicationTestCase.assertEquals((String)"juu", (String)c.getId());
        ApplicationTestCase.assertSame((Object)a, (Object)desc.getController().getMethodById("foo"));
        ApplicationTestCase.assertSame((Object)b, (Object)desc.getController().getMethodById("bar"));
        ApplicationTestCase.assertSame((Object)c, (Object)desc.getController().getMethodById("juu"));
    }

    public void _testDuplicateMethod() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "method", "duplicate");
        List<CompilationError> errors = compiler.failCompile();
        ApplicationTestCase.assertEquals((String)("Was expecting a single error instead of " + errors), (int)1, (int)errors.size());
        ApplicationTestCase.assertEquals((String)"/application/method/duplicate/A.java", (String)errors.get(0).getSource());
    }

    public void _testPrefix() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "prefix");
        compiler.assertCompile();
    }
}

