/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import juzu.Response;
import juzu.impl.request.spi.MimeBridge;
import juzu.io.AppendableStream;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRequestBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockMimeBridge
extends MockRequestBridge
implements MimeBridge {
    private Object result;
    private String mimeType;

    public MockMimeBridge(MockClient client, String methodId, Map<String, String[]> parameters) {
        super(client, methodId, parameters);
    }

    public String assertStringResult() {
        return AbstractTestCase.assertInstanceOf(String.class, this.result);
    }

    public byte[] assertBinaryResult() {
        return AbstractTestCase.assertInstanceOf(byte[].class, this.result);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void end(Response response) throws IllegalStateException, IOException {
        if (response instanceof Response.Content) {
            Response.Content content = (Response.Content)response;
            if (content.getKind() == Stream.Binary.class) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos);
                content.send((Stream)bos);
                this.result = baos.toByteArray();
            } else {
                StringBuilder builder = new StringBuilder();
                content.send((Stream)new AppendableStream((Appendable)builder));
                this.result = builder.toString();
            }
            this.mimeType = content.getMimeType();
        }
    }
}

