/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.controller.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import juzu.impl.controller.descriptor.ControllerBean;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.utils.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerDescriptor
extends Descriptor {
    private final Class<?> defaultController;
    private final List<ControllerBean> controllers;
    private final List<ControllerMethod> methods;
    private final ArrayList<BeanDescriptor> beans;
    private final Boolean escapeXML;

    public ControllerDescriptor(ClassLoader loader, JSON config) throws Exception {
        ArrayList<ControllerBean> controllers = new ArrayList<ControllerBean>();
        ArrayList<ControllerMethod> controllerMethods = new ArrayList<ControllerMethod>();
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        for (String fqn : config.getList("controllers", String.class)) {
            Class<?> clazz = loader.loadClass(fqn);
            Field f = clazz.getField("DESCRIPTOR");
            ControllerBean controller = (ControllerBean)f.get(null);
            controllers.add(controller);
            controllerMethods.addAll(controller.getMethods());
            beans.add(new BeanDescriptor(controller.getType(), null, null, null));
        }
        Boolean escapeXML = config.getBoolean("escapeXML");
        Class<?> defaultController = null;
        String defaultControllerName = config.getString("default");
        if (defaultControllerName != null) {
            defaultController = loader.loadClass(defaultControllerName);
        }
        this.escapeXML = escapeXML;
        this.defaultController = defaultController;
        this.controllers = controllers;
        this.methods = controllerMethods;
        this.beans = beans;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        return this.beans;
    }

    public Class<?> getDefault() {
        return this.defaultController;
    }

    public Boolean getEscapeXML() {
        return this.escapeXML;
    }

    public List<ControllerBean> getControllers() {
        return this.controllers;
    }

    public List<ControllerMethod> getMethods() {
        return this.methods;
    }

    public ControllerMethod getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        for (int i = 0; i < this.methods.size(); ++i) {
            Class<?>[] a;
            ControllerMethod cm = this.methods.get(i);
            Method m = cm.getMethod();
            if (!type.equals(cm.getType()) || !m.getName().equals(name) || (a = m.getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (a[j].equals(parameterTypes[j])) continue;
            }
            return cm;
        }
        return null;
    }

    public ControllerMethod getMethodById(String methodId) {
        for (int i = 0; i < this.methods.size(); ++i) {
            ControllerMethod cm = this.methods.get(i);
            if (!cm.getId().equals(methodId)) continue;
            return cm;
        }
        return null;
    }
}

