/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.controller.descriptor;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.Param;
import juzu.impl.controller.descriptor.ControllerParameter;
import juzu.impl.utils.ParameterMap;
import juzu.impl.utils.Tools;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControllerMethod {
    private final String id;
    private final Phase phase;
    private final Class<?> type;
    private final Method method;
    private final List<ControllerParameter> argumentList;
    private final Map<String, ControllerParameter> argumentMap;
    private final boolean requiresPrefix;

    public ControllerMethod(String id, Phase phase, Class<?> type, Method method, List<ControllerParameter> argumentList) {
        if (id == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(method.getDeclaringClass().getSimpleName());
            sb.append(".");
            sb.append(method.getName());
            id = sb.toString();
        }
        LinkedHashMap<String, ControllerParameter> argumentMap = new LinkedHashMap<String, ControllerParameter>();
        for (ControllerParameter argument : argumentList) {
            argumentMap.put(argument.getName(), argument);
        }
        boolean requiresPrefix = false;
        HashSet<String> set = new HashSet<String>();
        block1: for (ControllerParameter argument : argumentList) {
            if (argument.getType() == String.class) {
                if (set.add(argument.getName())) continue;
                requiresPrefix = true;
                break;
            }
            for (Field field : argument.getType().getFields()) {
                if (set.add(field.getName())) continue;
                requiresPrefix = true;
                break;
            }
            for (AccessibleObject accessibleObject : argument.getType().getMethods()) {
                String methodName = ((Method)accessibleObject).getName();
                if (methodName.length() <= 3 || !methodName.startsWith("get") || ((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).getReturnType() == Void.class) continue;
                String foo = methodName.substring(3);
                String name = Character.toLowerCase(methodName.charAt(0)) + foo.substring(1);
                if (set.add(name)) continue;
                requiresPrefix = true;
                continue block1;
            }
        }
        this.id = id;
        this.phase = phase;
        this.type = type;
        this.method = method;
        this.argumentList = Tools.safeUnmodifiableList(argumentList);
        this.argumentMap = Collections.unmodifiableMap(argumentMap);
        this.requiresPrefix = requiresPrefix;
    }

    public String getId() {
        return this.id;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.method.getName();
    }

    public ControllerParameter getArgument(String name) {
        return this.argumentMap.get(name);
    }

    public List<ControllerParameter> getArguments() {
        return this.argumentList;
    }

    public Set<String> getArgumentNames() {
        return this.argumentMap.keySet();
    }

    public void setArgs(Object[] args, ParameterMap parameterMap) {
        for (int j = 0; j < this.argumentList.size(); ++j) {
            Object value = args[j];
            if (value == null) continue;
            ControllerParameter parameter = this.argumentList.get(j);
            String name = parameter.getName();
            switch (parameter.getCardinality()) {
                case SINGLE: {
                    if (parameter.getType().isAnnotationPresent(Param.class)) {
                        Map<String, String[]> p = this.buildBeanParameter(name, value);
                        parameterMap.setParameters(p);
                        break;
                    }
                    parameterMap.setParameter(name, String.valueOf(value));
                    break;
                }
                case ARRAY: {
                    int length = Array.getLength(value);
                    String[] array = new String[length];
                    for (int i = 0; i < length; ++i) {
                        Object component = Array.get(value, i);
                        array[i] = String.valueOf(component);
                    }
                    parameterMap.setParameter(name, array);
                    break;
                }
                case LIST: {
                    Collection c = (Collection)value;
                    int length = c.size();
                    String[] array = new String[length];
                    Iterator iterator = c.iterator();
                    for (int i = 0; i < length; ++i) {
                        Object element = iterator.next();
                        array[i] = String.valueOf(element);
                    }
                    parameterMap.setParameter(name, array);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
            }
            parameter.setValue(parameterMap, value);
        }
    }

    private Map<String, String[]> buildBeanParameter(String baseName, Object value) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        try {
            Object v;
            for (Field field : value.getClass().getFields()) {
                v = field.get(value);
                if (v == null) continue;
                String name = this.requiresPrefix ? baseName + "." + field.getName() : field.getName();
                this.addParameter(parameters, name, field.getType(), v);
            }
            for (AccessibleObject accessibleObject : value.getClass().getMethods()) {
                if (!((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getName().length() <= 3 || ((Method)accessibleObject).getParameterTypes().length != 0 || (v = ((Method)accessibleObject).invoke(value, new Object[0])) == null) continue;
                String n = Character.toLowerCase(((Method)accessibleObject).getName().charAt(3)) + ((Method)accessibleObject).getName().substring(4);
                String name = this.requiresPrefix ? baseName + "." + n : n;
                this.addParameter(parameters, name, ((Method)accessibleObject).getReturnType(), v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return parameters;
    }

    private void addParameter(Map<String, String[]> parameters, String name, Class clazz, Object value) {
        if (String.class.equals((Object)clazz)) {
            parameters.put(name, new String[]{(String)value});
        } else if (String[].class.equals((Object)clazz)) {
            parameters.put(name, (String[])value);
        } else if (List.class.equals((Object)clazz)) {
            parameters.put(name, (String[])((List)value).toArray());
        }
    }

    public Object[] getArgs(Map<String, String[]> parameterMap) {
        Class<?>[] paramsType = this.method.getParameterTypes();
        Object[] args = new Object[this.argumentList.size()];
        block7: for (int i = 0; i < args.length; ++i) {
            Object[] values;
            ControllerParameter parameter = this.argumentList.get(i);
            if (paramsType[i].isAnnotationPresent(Param.class)) {
                Object o = null;
                try {
                    o = this.createMappedBean(paramsType[i], parameter.getName(), parameterMap);
                }
                catch (Exception e) {
                    // empty catch block
                }
                values = new Object[]{o};
            } else {
                values = parameterMap.get(parameter.getName());
            }
            if (values == null) continue;
            switch (parameter.getCardinality()) {
                case SINGLE: {
                    args[i] = values.length > 0 ? values[0] : null;
                    continue block7;
                }
                case ARRAY: {
                    args[i] = values.clone();
                    continue block7;
                }
                case LIST: {
                    ArrayList list = new ArrayList(values.length);
                    Collections.addAll(list, values);
                    args[i] = list;
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Handle me gracefully");
                }
            }
        }
        return args;
    }

    private <T> T createMappedBean(Class<T> clazz, String beanName, Map<String, String[]> parameters) throws IllegalAccessException, InstantiationException {
        HashMap<String, String[]> beanParams = new HashMap<String, String[]>();
        String prefix = this.requiresPrefix ? beanName + "." : "";
        for (String key : parameters.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String paramName = key.substring(prefix.length());
            beanParams.put(paramName, parameters.get(key));
        }
        T bean = clazz.newInstance();
        for (String key : beanParams.keySet()) {
            String[] value = (String[])beanParams.get(key);
            String setterName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
            boolean success = this.callSetter(setterName, clazz, bean, value, String[].class);
            if (!success) {
                success = this.callSetter(setterName, clazz, bean, value[0], String.class);
            }
            if (!success) {
                success = this.callSetter(setterName, clazz, bean, Arrays.asList(value), List.class);
            }
            if (success) continue;
            try {
                Field f = clazz.getField(key);
                if (String[].class.equals(f.getType())) {
                    f.set(bean, value);
                    continue;
                }
                if (String.class.equals(f.getType())) {
                    f.set(bean, value[0]);
                    continue;
                }
                if (!List.class.equals(f.getType())) continue;
                f.set(bean, Arrays.asList(value));
            }
            catch (NoSuchFieldException e) {}
        }
        return bean;
    }

    <T> boolean callSetter(String methodName, Class<T> clazz, T target, Object value, Class type) {
        try {
            Method m = clazz.getMethod(methodName, type);
            m.invoke(target, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[type=").append(this.type.getName()).append(",method=");
        sb.append(this.method.getName()).append("(");
        Class<?>[] types = this.method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.argumentList.get(i).getName()).append("=").append(types[i].getName());
        }
        sb.append(")]");
        return sb.toString();
    }
}

