/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.controller.metamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.controller.metamodel.ControllerMetaModel;
import juzu.impl.controller.metamodel.ParameterMetaModel;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerMethodMetaModel
extends MetaModelObject {
    ControllerMetaModel controller;
    final ElementHandle.Method handle;
    final String id;
    final Phase phase;
    final String name;
    final ArrayList<ParameterMetaModel> parameters;

    ControllerMethodMetaModel(ElementHandle.Method handle, String id, Phase phase, String name, ArrayList<ParameterMetaModel> parameters) {
        this.handle = handle;
        this.id = id;
        this.phase = phase;
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("handle", this.handle);
        json.set("id", this.id);
        json.set("phase", (Object)this.phase);
        json.set("name", this.name);
        json.map("parameters", new ArrayList<ParameterMetaModel>(this.parameters));
        return json;
    }

    public ControllerMetaModel getController() {
        return this.controller;
    }

    public ElementHandle.Method getHandle() {
        return this.handle;
    }

    public String getId() {
        return this.id;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<ParameterMetaModel> getParameters() {
        return this.parameters;
    }

    public ParameterMetaModel getParameter(int index) {
        return this.parameters.get(index);
    }

    public Set<String> getParameterNames() {
        HashSet<String> tmp = new HashSet<String>();
        for (ParameterMetaModel param : this.parameters) {
            tmp.add(param.getName());
        }
        return tmp;
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        this.controller = (ControllerMetaModel)parent;
    }

    @Override
    public boolean exist(MetaModel model) {
        AnnotationMirror am;
        ExecutableElement methodElt = model.env.get(this.handle);
        if (methodElt != null && (am = Tools.getAnnotation(methodElt, this.phase.annotation.getName())) != null) {
            AnnotationData values = AnnotationData.create(am);
            String id = (String)values.get("id");
            return Tools.safeEquals(id, this.id);
        }
        return false;
    }
}

