/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import juzu.Scope;
import juzu.impl.inject.spi.cdi.AbstractSingletonBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SingletonBean
extends AbstractSingletonBean {
    private final Object instance;
    private final Lock lock;
    private boolean initialized;
    private AnnotatedType at;
    private InjectionTarget it;

    SingletonBean(Class type, Iterable<Annotation> qualifiers, Object instance) {
        super(type, Scope.SINGLETON, qualifiers);
        this.instance = instance;
        this.initialized = false;
        this.lock = new ReentrantLock();
    }

    @Override
    void register(BeanManager manager) {
        super.register(manager);
        this.at = manager.createAnnotatedType(this.instance.getClass());
        this.it = manager.createInjectionTarget(this.at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(CreationalContext creationalContext) {
        this.lock.lock();
        try {
            if (!this.initialized) {
                if (this.it != null) {
                    this.it.inject(this.instance, creationalContext);
                    this.it.postConstruct(this.instance);
                }
                this.initialized = true;
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(Object instance, CreationalContext ctx) {
        this.lock.lock();
        try {
            if (this.initialized) {
                if (this.it != null) {
                    this.it.preDestroy(instance);
                    this.it.dispose(instance);
                }
                this.initialized = false;
            }
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        return "SingletonBean[type=" + this.type + ",qualifiers=" + this.qualifiers + "]";
    }
}

