/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.Response;
import juzu.impl.request.spi.ActionBridge;
import juzu.impl.request.spi.portlet.PortletBridgeContext;
import juzu.impl.request.spi.portlet.PortletRequestBridge;
import juzu.portlet.JuzuPortlet;
import juzu.request.RenderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletActionBridge
extends PortletRequestBridge<ActionRequest, ActionResponse>
implements ActionBridge {
    private boolean done = false;

    public PortletActionBridge(PortletBridgeContext context, ActionRequest actionRequest, ActionResponse actionResponse, boolean prod) {
        super(context, actionRequest, actionResponse, prod);
    }

    @Override
    public void end(Response response) throws IllegalStateException, IOException {
        if (this.done) {
            throw new IllegalStateException();
        }
        if (response instanceof Response.Update) {
            WindowState windowState;
            PortletMode portletMode;
            Response.Update update = (Response.Update)response;
            for (Map.Entry<String, String[]> entry : update.getParameters().entrySet()) {
                ((ActionResponse)this.resp).setRenderParameter(entry.getKey(), entry.getValue());
            }
            String methodId = update.getProperties().getValue(RenderContext.METHOD_ID);
            if (methodId != null) {
                ((ActionResponse)this.resp).setRenderParameter("juzu.op", methodId);
            }
            if ((portletMode = update.getProperties().getValue(JuzuPortlet.PORTLET_MODE)) != null) {
                try {
                    ((ActionResponse)this.resp).setPortletMode(portletMode);
                }
                catch (PortletModeException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if ((windowState = update.getProperties().getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                try {
                    ((ActionResponse)this.resp).setWindowState(windowState);
                }
                catch (WindowStateException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (response instanceof Response.Redirect) {
            Response.Redirect redirect = (Response.Redirect)response;
            ((ActionResponse)this.resp).sendRedirect(redirect.getLocation());
        }
        this.done = true;
    }
}

